% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_functions4Fitting.R
\name{markovchainListFit}
\alias{markovchainListFit}
\title{markovchainListFit}
\usage{
markovchainListFit(data, byrow = TRUE, laplacian = 0, name)
}
\arguments{
\item{data}{Either a matrix or a data.frame or a list object.}

\item{byrow}{Indicates whether distinc stochastic processes trajectiories are shown in distinct rows.}

\item{laplacian}{Laplacian correction (default 0).}

\item{name}{Optional name.}
}
\value{
A list containing two slots:
estimate (the estimate)
name
}
\description{
Given a data frame or a matrix (rows are observations, by cols 
the temporal sequence), it fits a non - homogeneous discrete time markov chain 
process (storing row). In particular a markovchainList of size = ncol - 1 is obtained
estimating transitions from the n samples given by consecutive column pairs.
}
\details{
If \code{data} contains \code{NAs} then the transitions containing \code{NA} will be ignored.
}
\examples{

# using holson dataset
data(holson)
# fitting a single markovchain
singleMc <- markovchainFit(data = holson[,2:12])
# fitting a markovchainList
mclistFit <- markovchainListFit(data = holson[, 2:12], name = "holsonMcList")
}
