% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{set_mass_props_and_unc}
\alias{set_mass_props_and_unc}
\title{Set mass properties and uncertainties for a row in a data frame}
\usage{
set_mass_props_and_unc(df, id, mpu)
}
\arguments{
\item{df}{A data frame with an \code{id} column.}

\item{id}{The \code{id} value of the desired row.}

\item{mpu}{A list containing the following named elements:
\itemize{
\item \code{mass} Numeric mass.
\item \code{center_mass} Numeric 3-vector center of mass.
\item \code{point} Logical indicating point mass. The inertia of point masses is excluded from calculations.
\item \code{poi_conv} Enumeration c("+", "-") indicating sign convention for products of inertia.
\item \code{inertia} Numeric 3x3 matrix inertia tensor. The signs of the products of inertia
are determined by \code{POIconv}. For example, \code{Ixy} is the \eqn{xy} element of the inertia
tensor if \code{POIconv} is "-"; it is the additive inverse of that value if \code{POIconv} is "+".
\item \code{sigma_mass} Numeric mass uncertainty.
\item \code{sigma_center_mass} Numeric 3-vector center of mass uncertainties.
\item \code{sigma_inertia} Numeric 3x3 matrix inertia tensor uncertainties.
}}
}
\value{
The updated data frame.
}
\description{
\code{set_mass_props_and_unc()} is a convenience wrapper that combines the results of
\code{set_mass_props()} and \code{set_mass_props_unc()}.
}
\examples{
mpu <- c(get_mass_props_and_unc(sawe_table, "Widget"), poi_conv = "+")
set_mass_props_and_unc(sawe_table, "Combined", mpu)

}
