% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle_sections_figures.R
\name{slice}
\alias{slice}
\title{Coordinates of a pizza slice}
\usage{
slice(
  size.x = 15,
  size.y = 0,
  pos.x = 0,
  pos.y = 0,
  theta1 = pi/4,
  theta2 = 3 * pi/4,
  lty = 1,
  lwd = 3,
  vis = 1,
  shd = NA
)
}
\arguments{
\item{size.x}{integer, length of the semi-major axis of the ellipse within which the figure is inscribed. Default is 15}

\item{size.y}{integer, length of the semi-major axis of the ellipse within which the figure is inscribed. Default is 0}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}

\item{theta1}{Starting angle of the circle section. Default is \eqn{\frac{\pi}{4}}}

\item{theta2}{Ending angle of the circle section (built counterclockwise). Default is  \eqn{\frac{3\pi}{4}}}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line)}

\item{lwd}{integer, define the line width of the figure. Default is 3}

\item{vis}{Visibility of the figure. Default is 1, making the figure visible. To hide the figure, change it to 0}

\item{shd}{character, define the shading of the figure. Default is NA which results in a transparent figure}
}
\value{
Return the coordinates for drawing a circle section
}
\description{
Define the coordinates for drawing a circle section
}
\examples{
# default coordinates of the pizza slice
slice()
# change the rotation of the pizza slice
slice(theta1 = 3*pi/4, theta2 = 5*pi/4)
}
