% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mb_get_events.R
\name{mb_get_events}
\alias{mb_get_events}
\title{Get List of Available Events}
\usage{
mb_get_events(session_data, sport_ids = NULL, start_date = NULL,
  end_date = NULL, market_states = c("open", "suspended"))
}
\arguments{
\item{session_data}{A session object returned from a successful mb_login attempt. It contains details about your user preferences and security details.}

\item{sport_ids}{A vector of integer sport_ids that indicate sports for which event details are required. e.g. c(15,1) gives Soccer and Pro Football (NFL)}

\item{start_date}{A string (or date/POSIXct) value with format YYYY-mm-dd or YYYY-mm-dd HH:MM:SS format.}

\item{end_date}{A string (or date/POSIXct) value with format YYYY-mm-dd or YYYY-mm-dd HH:MM:SS format.}

\item{market_states}{A vector of string containing the market states to return. Defaults to 'open' or 'suspended' market types.}
}
\value{
If successful, a dataframe with first 500 events and associated information. Only 500 events are permitted at one time. Pagination is possible but not implemented in this version.
The data frame has the following fields:
 \describe{
  \item{id}{Event id}
  \item{name}{Event name}
  \item{start}{The start date of the event}
  \item{status}{If betting is still available on this event it will have status='open'}
  \item{sport-id}{The sport id of this event} 
  \item{category-id}{The category of the event e.g. Premier League is a category within Football/Soccer}
  \item{in-running-flag}{Is the market currently in-running}
  \item{allow-live-betting}{Is it possible for this market to go in running}
  \item{market-ids}{The ids of the markets within this event}
  \item{meta-tags}{Tags describing the event}
}
}
\description{
List the Events Available on Matchbook.com
}
\examples{
\dontrun{my_session <- mb_login("my_user_name","verysafepassword"); 
mb_get_events(session_data=my_session,sport_ids=15)}

}
\seealso{
\code{\link{mb_get_sports},\link{mb_get_markets}}
}

