/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.visu;

import choco.kernel.visu.IVisuManager;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public abstract class AbstractVisuManager
implements IVisuManager {
    protected int defaultWidth;
    protected int defaultHeight;

    @Override
    public final int getDefaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public final void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    @Override
    public final int getDefaultHeight() {
        return this.defaultHeight;
    }

    @Override
    public final void setDefaultHeight(int defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    protected abstract String getFileExtension();

    protected abstract boolean doExport(File var1, Object var2, int var3, int var4) throws IOException;

    protected abstract boolean doShow(Object var1, int var2, int var3);

    @Override
    public File export(File dir, String name, Object chart) {
        return this.export(dir, name, chart, this.getDefaultWidth(), this.getDefaultHeight());
    }

    @Override
    public File export(File dir, String name, Object chart, int width, int height) {
        try {
            File file;
            String ext = '.' + this.getFileExtension();
            if (name == null) {
                name = "visu";
            }
            if (dir == null) {
                file = File.createTempFile(name, ext);
            } else {
                file = new File(dir, name + '.' + this.getFileExtension());
                if (file.exists()) {
                    file = File.createTempFile(name + "-", '.' + this.getFileExtension(), dir);
                }
            }
            if (this.doExport(file, chart, width, height)) {
                LOGGER.log(Level.CONFIG, "visu...[export:{0}][OK]", file);
                return file;
            }
            LOGGER.log(Level.WARNING, "visu...[export:{0}][FAIL]", file);
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "visu...[export:{0}][FAIL]", e);
            return null;
        }
    }

    @Override
    public void show(Object chart) {
        this.show(chart, this.getDefaultWidth(), this.getDefaultHeight());
    }

    @Override
    public void show(Object chart, int width, int height) {
        if (this.doShow(chart, width, height)) {
            LOGGER.config("visu...[show][OK]");
        } else {
            LOGGER.warning("visu...[show][FAIL]");
        }
    }
}

