/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.layers;

import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistGeq;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistLeq;
import choco.cp.solver.constraints.global.geost.externalConstraints.DistLinear;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.externalConstraints.NonOverlapping;
import choco.cp.solver.constraints.global.geost.frames.DistLinearFrame;
import choco.cp.solver.constraints.global.geost.frames.ForbiddenRegionFrame;
import choco.cp.solver.constraints.global.geost.frames.Frame;
import choco.cp.solver.constraints.global.geost.frames.NonOverlappingFrame;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.DistGeqIC;
import choco.cp.solver.constraints.global.geost.internalConstraints.DistLeqIC;
import choco.cp.solver.constraints.global.geost.internalConstraints.DistLinearIC;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.cp.solver.constraints.global.geost.internalConstraints.Outbox;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.constraints.geost.GeostOptions;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.solver.SolverException;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public final class ExternalLayer {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    Constants cst;
    Setup stp;

    public ExternalLayer(Constants c, Setup s) {
        this.cst = c;
        this.stp = s;
    }

    public Frame InitFrameExternalConstraint(ExternalConstraint ectr, int[] oIDs) {
        Frame result;
        switch (ectr.getEctrID()) {
            case 1: {
                result = this.initFrameExternalConstraintForCompatible();
                break;
            }
            case 2: {
                result = this.initFrameExternalConstraintForIncluded();
                break;
            }
            case 3: {
                result = this.initFrameExternalConstraintForNonOverlapping(oIDs);
                break;
            }
            case 4: {
                result = this.initFrameExternalConstraintForVisible();
                break;
            }
            case 5: {
                result = this.InitFrameExternalConstraintForDistLeq((DistLeq)ectr, oIDs);
                break;
            }
            case 6: {
                result = this.initFrameExternalConstraintForDistGeq((DistGeq)ectr);
                break;
            }
            case 7: {
                result = this.InitFrameExternalConstraintForDistLinear((DistLinear)ectr, oIDs);
                break;
            }
            case 8: {
                result = this.initFrameExternalConstraintForNonOverlappingCircle();
                break;
            }
            default: {
                throw new SolverException("A call to InitFrameExternalConstraint with incorrect ectr parameter");
            }
        }
        return result;
    }

    public List<InternalConstraint> genInternalCtrs(ExternalConstraint ectr, Obj o) {
        List<InternalConstraint> result;
        switch (ectr.getEctrID()) {
            case 1: {
                result = this.genInternalCtrsForCompatible();
                break;
            }
            case 2: {
                result = this.genInternalCtrsForIncluded();
                break;
            }
            case 3: {
                result = this.genInternalCtrsForNonOverlapping((NonOverlapping)ectr, o);
                break;
            }
            case 4: {
                result = this.genInternalCtrsForVisible();
                break;
            }
            case 5: {
                result = this.genInternalCtrsForDistLeq((DistLeq)ectr);
                break;
            }
            case 6: {
                result = this.genInternalCtrsForDistGeq((DistGeq)ectr);
                break;
            }
            case 7: {
                result = this.genInternalCtrsForDistLinear((DistLinear)ectr);
                break;
            }
            default: {
                throw new SolverException("A call to GenInternalCstrs with incorrect ectr parameter");
            }
        }
        return result;
    }

    private Frame initFrameExternalConstraintForCompatible() {
        return new NonOverlappingFrame();
    }

    private Frame initFrameExternalConstraintForIncluded() {
        return new NonOverlappingFrame();
    }

    private Frame initFrameExternalConstraintForNonOverlapping(int[] oIDs) {
        NonOverlappingFrame f = new NonOverlappingFrame();
        for (int i = 0; i < oIDs.length; ++i) {
            Obj o = this.stp.getObject(oIDs[i]);
            int m = o.getShapeId().getDomainSize();
            ArrayList<Region> regions = new ArrayList<Region>();
            int[][] set = new int[m][];
            int ivalue = 0;
            int sid = o.getShapeId().getInf();
            while (sid <= o.getShapeId().getSup()) {
                int nbOfSbox = this.stp.getShape(sid).size();
                set[ivalue] = new int[nbOfSbox];
                for (int j = 0; j < nbOfSbox; ++j) {
                    set[ivalue][j] = j;
                }
                ++ivalue;
                sid = o.getShapeId().getNextDomainValue(sid);
            }
            int[] pointer = new int[m];
            boolean print = true;
            block3: do {
                int j;
                Region r = new Region(this.cst.getDIM(), o.getObjectId());
                for (j = 0; j < this.cst.getDIM(); ++j) {
                    int max = this.stp.getShape(o.getShapeId().getInf()).get(set[0][pointer[0]]).getOffset(j);
                    int min = this.stp.getShape(o.getShapeId().getInf()).get(set[0][pointer[0]]).getOffset(j) + this.stp.getShape(o.getShapeId().getInf()).get(set[0][pointer[0]]).getSize(j);
                    int curDomVal = o.getShapeId().getNextDomainValue(o.getShapeId().getInf());
                    for (int s = 1; s < m; ++s) {
                        max = Math.max(max, this.stp.getShape(curDomVal).get(set[s][pointer[s]]).getOffset(j));
                        min = Math.min(min, this.stp.getShape(curDomVal).get(set[s][pointer[s]]).getOffset(j) + this.stp.getShape(curDomVal).get(set[s][pointer[s]]).getSize(j));
                        curDomVal = o.getShapeId().getNextDomainValue(curDomVal);
                    }
                    r.setMinimumBoundary(j, o.getCoord(j).getSup() + max + 1);
                    r.setMaximumBoundary(j, o.getCoord(j).getInf() + min - 1);
                }
                regions.add(r);
                for (j = m - 1; j >= 0; --j) {
                    if (pointer[j] == set[j].length - 1) {
                        if (j == 0) {
                            print = false;
                        }
                    } else {
                        int n = j;
                        pointer[n] = pointer[n] + 1;
                        continue block3;
                    }
                    pointer[j] = 0;
                }
            } while (print);
            f.addForbidRegions(o.getObjectId(), regions);
        }
        return f;
    }

    private Frame InitFrameExternalConstraintForDistLeq(DistLeq ectr, int[] oIDs) {
        int s1 = this.stp.getObject(ectr.o1).getShapeId().getVal();
        int s2 = this.stp.getObject(ectr.o2).getShapeId().getVal();
        ForbiddenRegionFrame f = new ForbiddenRegionFrame(ectr.q, ectr.D, s1, s2, ectr.o1, ectr.o2);
        for (int i = 0; i < oIDs.length; ++i) {
            Obj o = this.stp.getObject(oIDs[i]);
            ArrayList<Region> regions = new ArrayList<Region>();
            f.addForbidRegions(o.getObjectId(), regions);
        }
        return f;
    }

    private Frame initFrameExternalConstraintForDistGeq(DistGeq ectr) {
        int s1 = this.stp.getObject(ectr.o1).getShapeId().getVal();
        int s2 = this.stp.getObject(ectr.o2).getShapeId().getVal();
        return new ForbiddenRegionFrame(ectr.q, ectr.D, s1, s2, ectr.o1, ectr.o2);
    }

    private Frame InitFrameExternalConstraintForDistLinear(DistLinear ectr, int[] oIDs) {
        DistLinearFrame f = new DistLinearFrame(ectr.a, ectr.o1, ectr.b);
        for (int i = 0; i < oIDs.length; ++i) {
            Obj o = this.stp.getObject(oIDs[i]);
            ArrayList<Region> regions = new ArrayList<Region>();
            f.addForbidRegions(o.getObjectId(), regions);
        }
        return f;
    }

    private Frame initFrameExternalConstraintForVisible() {
        return new NonOverlappingFrame();
    }

    private Frame initFrameExternalConstraintForNonOverlappingCircle() {
        return new NonOverlappingFrame();
    }

    private List<InternalConstraint> genInternalCtrsForCompatible() {
        return new ArrayList<InternalConstraint>();
    }

    private List<InternalConstraint> genInternalCtrsForIncluded() {
        return new ArrayList<InternalConstraint>();
    }

    public Pair<Outbox, Boolean> mergeAdjacent(Outbox new_ob, Outbox last_ob) {
        int dim = new_ob.adjacent(last_ob);
        if (dim != -1 && !new_ob.sameSize(last_ob, dim)) {
            dim = -1;
        }
        if (dim != -1) {
            new_ob.merge(last_ob, dim);
        }
        return new Pair<Outbox, Boolean>(new_ob, dim != -1);
    }

    private List<InternalConstraint> genInternalCtrsForNonOverlapping(NonOverlapping ectr, Obj o) {
        ArrayList<InternalConstraint> ictrs = new ArrayList<InternalConstraint>();
        List<ShiftedBox> sb = this.stp.getShape(o.getShapeId().getInf());
        Iterator<Integer> itr = ectr.getFrame().getRelForbidRegions().keySet().iterator();
        boolean printit = false;
        while (itr.hasNext()) {
            int i = itr.next();
            if (o.getObjectId() == i) continue;
            for (int k = 0; k < sb.size(); ++k) {
                block2: for (int l = 0; l < ectr.getFrame().getRelForbidRegions(i).size(); ++l) {
                    int[] t = new int[this.cst.getDIM()];
                    int[] s = new int[this.cst.getDIM()];
                    for (int j = 0; j < this.cst.getDIM(); ++j) {
                        int minObj;
                        int min = ectr.getFrame().getRelForbidRegions(i).get(l).getMinimumBoundary(j) - sb.get(k).getOffset(j) - sb.get(k).getSize(j);
                        int max = ectr.getFrame().getRelForbidRegions(i).get(l).getMaximumBoundary(j) - sb.get(k).getOffset(j);
                        s[j] = max - min + 1;
                        if (s[j] <= 0) continue block2;
                        t[j] = min;
                        if (printit) {
                            LOGGER.info(o.getObjectId() + " " + j + " " + o);
                        }
                        int supDom = o.getCoord(j).getSup();
                        int infDom = o.getCoord(j).getInf();
                        int maxObj = o.getCoord(j).getSup() + sb.get(k).getOffset(j) + sb.get(k).getSize(j) - 1;
                        if (maxObj > o.getCoord(j).getSup()) {
                            maxObj = o.getCoord(j).getSup();
                        }
                        if ((minObj = o.getCoord(j).getInf() + sb.get(k).getOffset(j)) < o.getCoord(j).getInf()) {
                            minObj = o.getCoord(j).getInf();
                        }
                        if (printit) {
                            LOGGER.info("box: " + t[j] + " " + s[j]);
                        }
                        if (printit) {
                            LOGGER.info("dom: " + minObj + " " + maxObj);
                        }
                        if (supDom < t[j] || infDom > t[j] + s[j]) {
                            if (!printit) continue block2;
                            LOGGER.info("skip");
                            continue block2;
                        }
                        if (maxObj < t[j] || minObj > t[j] + s[j]) {
                            if (!printit) continue block2;
                            LOGGER.info("skip2");
                            continue block2;
                        }
                        GeostOptions cfr_ignored_0 = this.stp.opt;
                        if (GeostOptions.clipping) {
                            // empty if block
                        }
                        if (!printit) continue;
                        LOGGER.info("result box: " + t[j] + " " + s[j]);
                    }
                    Outbox new_ob = new Outbox(t, s);
                    if (ictrs.size() != 0) {
                        Outbox last_ob = (Outbox)ictrs.get(ictrs.size() - 1);
                        Pair<Outbox, Boolean> result = this.mergeAdjacent(new_ob, last_ob);
                        new_ob = (Outbox)result.fst;
                        if (((Boolean)result.snd).booleanValue()) {
                            ictrs.remove(ictrs.size() - 1);
                        }
                    }
                    ictrs.add(new_ob);
                }
            }
        }
        return ictrs;
    }

    private List<InternalConstraint> genInternalCtrsForVisible() {
        return new ArrayList<InternalConstraint>();
    }

    private List<InternalConstraint> genInternalCtrsForDistGeq(DistGeq ectr) {
        ArrayList<InternalConstraint> ictrs = new ArrayList<InternalConstraint>();
        ForbiddenRegionFrame f = (ForbiddenRegionFrame)ectr.getFrame();
        DistGeqIC ic = new DistGeqIC(this.stp, f.q, f.D, f.s1, f.s2, f.o1, f.o2, ectr.getDistanceVar());
        ictrs.add(ic);
        return ictrs;
    }

    private List<InternalConstraint> genInternalCtrsForDistLeq(DistLeq ectr) {
        ArrayList<InternalConstraint> ictrs = new ArrayList<InternalConstraint>();
        ForbiddenRegionFrame f = (ForbiddenRegionFrame)ectr.getFrame();
        DistLeqIC ic = new DistLeqIC(this.stp, f.q, f.D, f.s1, f.s2, f.o1, f.o2, ectr.getDistanceVar());
        ictrs.add(ic);
        return ictrs;
    }

    private List<InternalConstraint> genInternalCtrsForDistLinear(DistLinear ectr) {
        ArrayList<InternalConstraint> ictrs = new ArrayList<InternalConstraint>();
        DistLinearFrame f = (DistLinearFrame)ectr.getFrame();
        DistLinearIC ic = new DistLinearIC(this.stp, f.a, f.o1, f.b);
        ictrs.add(ic);
        return ictrs;
    }
}

