/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.expressions;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.reified.leaves.bool.EqNode;
import choco.cp.solver.constraints.reified.leaves.bool.GeqNode;
import choco.cp.solver.constraints.reified.leaves.bool.GtNode;
import choco.cp.solver.constraints.reified.leaves.bool.LeqNode;
import choco.cp.solver.constraints.reified.leaves.bool.LtNode;
import choco.cp.solver.constraints.reified.leaves.bool.NeqNode;
import choco.cp.solver.constraints.reified.leaves.bool.NotNode;
import choco.cp.solver.constraints.reified.leaves.bool.OppSignNode;
import choco.cp.solver.constraints.reified.leaves.bool.SameSignNode;
import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.MetaConstraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.reified.INode;
import java.util.List;

public final class NotManager
extends IntConstraintManager {
    public SConstraint makeConstraint(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        Constraint[] constraints;
        if (solver instanceof CPSolver && (constraints = (Constraint[])((Object[])parameters)[1]).length == 1) {
            Constraint c = constraints[0];
            boolean decomp = false;
            if (c.getOptions().contains("cp:decomp")) {
                decomp = true;
            }
            SConstraint[] ct = ((CPSolver)solver).makeSConstraintAndOpposite(c, decomp);
            return ct[1];
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }

    @Override
    public INode makeNode(Solver solver, Constraint[] cstrs, Variable[] vars) {
        MetaConstraint mc = (MetaConstraint)cstrs[0];
        Constraint cons = mc.getConstraints()[0];
        if (cons instanceof ComponentConstraint) {
            return this.detectSimpleNode(solver, cons);
        }
        INode[] nt = new INode[mc.getConstraints().length];
        for (int i = 0; i < mc.getConstraints().length; ++i) {
            Constraint c = mc.getConstraints()[i];
            Variable[] ev = new Variable[c.getNbVars()];
            for (int j = 0; j < c.getNbVars(); ++j) {
                ev[j] = c.getVariables()[j];
            }
            nt[i] = c.getExpressionManager().makeNode(solver, new Constraint[]{c}, ev);
        }
        return new NotNode(nt);
    }

    private INode detectSimpleNode(Solver solver, Constraint cons) {
        ComponentConstraint cc = (ComponentConstraint)cons;
        ConstraintType type = cc.getConstraintType();
        switch (type) {
            case EQ: {
                return new NeqNode(NotManager.buildVariableNodes(solver, cc));
            }
            case NEQ: {
                return new EqNode(NotManager.buildVariableNodes(solver, cc));
            }
            case GEQ: {
                return new LtNode(NotManager.buildVariableNodes(solver, cc));
            }
            case LEQ: {
                return new GtNode(NotManager.buildVariableNodes(solver, cc));
            }
            case GT: {
                return new LeqNode(NotManager.buildVariableNodes(solver, cc));
            }
            case LT: {
                return new GeqNode(NotManager.buildVariableNodes(solver, cc));
            }
            case SIGNOP: {
                if (cc.getParameters() == Boolean.FALSE) {
                    return new SameSignNode(NotManager.buildVariableNodes(solver, cc));
                }
                if (cc.getParameters() != Boolean.TRUE) break;
                return new OppSignNode(NotManager.buildVariableNodes(solver, cc));
            }
        }
        INode[] nt = new INode[1];
        Variable[] ev = new IntegerExpressionVariable[cons.getNbVars()];
        for (int j = 0; j < cons.getNbVars(); ++j) {
            ev[j] = (IntegerExpressionVariable)cons.getVariables()[j];
        }
        nt[0] = cons.getExpressionManager().makeNode(solver, new Constraint[]{cons}, ev);
        return new NotNode(nt);
    }

    private static INode[] buildVariableNodes(Solver solver, ComponentConstraint cc) {
        INode[] nt = new INode[cc.getVariables().length];
        for (int i = 0; i < cc.getVariables().length; ++i) {
            IntegerExpressionVariable v = (IntegerExpressionVariable)cc.getVariable(i);
            nt[i] = v.getExpressionManager().makeNode(solver, v.getConstraints(), v.getVariables());
        }
        return nt;
    }
}

