/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.globalCardConstraint;

import choco.cp.solver.constraints.global.tree.filtering.structuralFiltering.globalCardConstraint.AbstractBipartGraph;
import choco.kernel.solver.Solver;

public abstract class AbstractBipartFlow
extends AbstractBipartGraph {
    protected int[] minFlow;
    protected int[] maxFlow;
    protected int[] flow;
    protected boolean compatibleFlow;

    protected AbstractBipartFlow(Solver solver, Object[] pack) {
        super(solver, pack);
        this.initAbstractBipartFlow();
    }

    protected void initAbstractBipartFlow() {
        this.flow = new int[this.nbRightVertices];
        this.minFlow = new int[this.nbRightVertices];
        this.maxFlow = new int[this.nbRightVertices];
        this.left2rightArc = new int[this.nbLeftVertices + 1];
        this.queue = new AbstractBipartGraph.IntQueue(this.nbVertices);
    }

    @Override
    public void setMatch(int i, int j) {
        assert (1 <= i && i <= this.nbLeftVertices && 1 <= j && j <= this.nbRightVertices);
        int j0 = this.refMatch[i];
        if (j0 != j) {
            if (j0 >= 0) {
                this.refMatch[i] = -1;
                this.decreaseMatchingSize(j0);
            }
            if (this.flow[j] < this.maxFlow[j] && (j0 == -1 || this.flow[j0] >= this.minFlow[j0])) {
                this.refMatch[i] = j;
                this.increaseMatchingSize(j);
            }
        }
    }

    @Override
    public void deleteMatch(int i, int j) {
        if (j == this.refMatch[i]) {
            this.refMatch[i] = -1;
            this.decreaseMatchingSize(j);
        }
    }

    @Override
    public void putRefMatch(int i, int j) {
        this.refMatch[i] = j;
    }

    @Override
    public boolean mayDiminishFlowFromSource(int j) {
        return this.flow[j] > this.minFlow[j];
    }

    @Override
    public boolean mayGrowFlowFromSource(int j) {
        return this.flow[j] < this.maxFlow[j];
    }

    @Override
    public boolean mustGrowFlowFromSource(int j) {
        return this.flow[j] < this.minFlow[j];
    }

    @Override
    public void increaseMatchingSize(int j) {
        ++this.matchingSize;
        int n = j;
        this.flow[n] = this.flow[n] + 1;
    }

    @Override
    public void decreaseMatchingSize(int j) {
        --this.matchingSize;
        int n = j;
        this.flow[n] = this.flow[n] - 1;
    }

    @Override
    public int findAlternatingPath() {
        int j;
        int eopath = -1;
        int n = this.nbLeftVertices;
        int m = this.nbRightVertices;
        this.queue.init();
        for (j = 0; j < this.nbRightVertices; ++j) {
            if (!this.mustGrowFlowFromSource(j)) continue;
            this.queue.push(j + n);
        }
        if (this.queue.getSize() == 0) {
            this.compatibleFlow = true;
            for (j = 0; j < this.nbRightVertices; ++j) {
                if (!this.mayGrowFlowFromSource(j)) continue;
                this.queue.push(j + n);
            }
        } else {
            this.compatibleFlow = false;
        }
        while (this.queue.getSize() > 0) {
            int x = this.queue.pop();
            if (x >= n && x < m + n) {
                int[] yy;
                boolean shouldBreak = false;
                for (int y : yy = this.mayInverseMatch(x -= n)) {
                    if (!this.mayGrowFlowBetween(x, y) || this.queue.onceInQueue(y)) continue;
                    this.left2rightArc[y] = x;
                    if (this.mayGrowFlowToSink(y)) {
                        eopath = y;
                        shouldBreak = true;
                        break;
                    }
                    this.queue.push(y);
                }
                if (!this.compatibleFlow && this.mayDiminishFlowFromSource(x) && !this.queue.onceInQueue(n + m)) {
                    this.left2rightArc[n] = x;
                    this.queue.push(n + m);
                }
                if (!shouldBreak) continue;
                break;
            }
            if (x < n) {
                int y = this.match(x);
                if (this.queue.onceInQueue(y + n)) continue;
                this.right2leftArc[y] = x;
                this.queue.push(y + n);
                continue;
            }
            if (this.compatibleFlow) continue;
            for (int j2 = 0; j2 < this.nbRightVertices; ++j2) {
                if (!this.mayGrowFlowFromSource(j2) || this.queue.onceInQueue(j2 + n)) continue;
                this.right2leftArc[j2] = n;
                this.queue.push(j2 + n);
            }
        }
        return eopath;
    }

    @Override
    public void augment(int x) {
        int y = this.left2rightArc[x];
        if (this.compatibleFlow) {
            while (!this.mayGrowFlowFromSource(y)) {
                this.putRefMatch(x, y);
                x = this.right2leftArc[y];
                y = this.left2rightArc[x];
            }
        } else {
            int n = this.nbLeftVertices;
            while (!this.mustGrowFlowFromSource(y)) {
                this.putRefMatch(x, y);
                x = this.right2leftArc[y];
                if (x == n) {
                    this.increaseMatchingSize(y);
                    y = this.left2rightArc[x];
                    this.decreaseMatchingSize(y);
                    x = this.right2leftArc[y];
                }
                y = this.left2rightArc[x];
            }
        }
        this.putRefMatch(x, y);
        this.increaseMatchingSize(y);
    }
}

