/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solution;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.AbstractBranchingStrategy;
import choco.kernel.solver.branch.AbstractIntBranchingStrategy;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.ShavingTools;
import choco.kernel.solver.search.AbstractSearchLoop;
import choco.kernel.solver.search.AbstractSearchStrategy;
import choco.kernel.solver.search.GlobalSearchLimitManager;
import choco.kernel.solver.search.IObjectiveManager;
import choco.kernel.solver.search.IntBranchingTrace;
import choco.kernel.solver.search.limit.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.measure.ISearchMeasures;
import java.util.logging.Level;

public abstract class AbstractGlobalSearchStrategy
extends AbstractSearchStrategy
implements ISearchMeasures {
    public static final int INIT_SEARCH = 0;
    public static final int OPEN_NODE = 1;
    public static final int UP_BRANCH = 2;
    public static final int DOWN_BRANCH = 4;
    public static final int RESTART = 8;
    public static final int STOP = 16;
    protected int currentTraceIndex = -1;
    protected IntBranchingTrace[] traceStack;
    private final IntBranchingTrace initialTrace = new IntBranchingTrace();
    public int nextMove = 0;
    public final boolean stopAtFirstSol;
    protected AbstractGlobalSearchLimit encounteredLimit = null;
    public AbstractIntBranchingStrategy mainGoal;
    public int baseWorld = 0;
    public ShavingTools shavingTools;
    public GlobalSearchLimitManager limitManager;
    public AbstractSearchLoop searchLoop;
    protected long initialPropagation;

    protected AbstractGlobalSearchStrategy(Solver solver) {
        super(solver);
        this.traceStack = new IntBranchingTrace[solver.getNbIntVars() + solver.getNbSetVars()];
        this.nextMove = 0;
        this.stopAtFirstSol = solver.getConfiguration().readBoolean("cp.resolution.stop_at_first_solution");
    }

    public void initMainGoal(SConstraint c) {
        if (this.mainGoal != null) {
            this.mainGoal.initConstraintForBranching(c);
            for (AbstractBranchingStrategy branch = this.mainGoal.getNextBranching(); branch != null; branch = branch.getNextBranching()) {
                branch.initConstraintForBranching(c);
            }
        }
    }

    public IObjectiveManager getObjectiveManager() {
        return null;
    }

    public final GlobalSearchLimitManager getLimitManager() {
        return this.limitManager;
    }

    public final AbstractSearchLoop getSearchLoop() {
        return this.searchLoop;
    }

    public final ShavingTools getShavingTools() {
        return this.shavingTools;
    }

    public final void setShavingTools(ShavingTools shavingTools) {
        this.shavingTools = shavingTools;
    }

    public final void setSearchLoop(AbstractSearchLoop searchLoop) {
        this.searchLoop = searchLoop;
    }

    public final void setLimitManager(GlobalSearchLimitManager limitManager) {
        this.limitManager = limitManager;
    }

    protected final boolean isFeasibleRootState() {
        return this.solver.isFeasible() != Boolean.FALSE;
    }

    public final void initialPropagation() {
        long timer = -System.currentTimeMillis();
        try {
            this.newTreeSearch();
            this.solver.propagate();
            this.advancedInitialPropagation();
            this.newFeasibleRootState();
        }
        catch (ContradictionException e) {
            if (LOGGER.isLoggable(Level.FINE) && e.getContradictionCause() != null) {
                LOGGER.log(Level.FINE, "- Initial Propagation: Contradiction due to {0}", e.getContradictionCause());
            }
            this.solver.setFeasible(Boolean.FALSE);
        }
        this.initialPropagation = System.currentTimeMillis() + timer;
    }

    protected void advancedInitialPropagation() throws ContradictionException {
        if (this.solver.getConfiguration().readBoolean("cp.init.propagation.shaving")) {
            this.shavingTools.shaving();
        }
    }

    protected final void topDownSearch() {
        if (this.stopAtFirstSol) {
            this.nextSolution();
        } else {
            while (this.nextSolution() == Boolean.TRUE) {
            }
        }
    }

    public void incrementalRun() {
        this.initialPropagation();
        if (this.isFeasibleRootState()) {
            assert (this.solver.getWorldIndex() > this.baseWorld);
            this.topDownSearch();
        }
        this.endTreeSearch();
    }

    public void newTreeSearch() throws ContradictionException {
        assert (this.solver.getSearchStrategy() == this);
        LOGGER.info("** CHOCO : Constraint Programming Solver\n** CHOCO v2.1.5 (August, 2012), Copyleft (c) 1999-2012");
        this.baseWorld = this.solver.getWorldIndex();
        this.resetSolutions();
        this.initialTrace.setBranching(this.mainGoal);
        this.solver.getPropagationEngine().getFailMeasure().safeReset();
        this.limitManager.initialize();
        this.searchLoop.initialize();
    }

    public void newFeasibleRootState() {
        this.solver.worldPush();
    }

    public void endTreeSearch() {
        if (!this.solutionPool.isEmpty() && !this.stopAtFirstSol) {
            this.solver.worldPopUntil(this.baseWorld);
            this.restoreBestSolution();
        }
        if (!this.isEncounteredLimit() && !this.existsSolution()) {
            this.solver.setFeasible(Boolean.FALSE);
        }
        this.limitManager.endTreeSearch();
        if (LOGGER.isLoggable(Level.INFO)) {
            if (this.isEncounteredLimit()) {
                LOGGER.log(Level.INFO, "- Search incompleted: Exiting on limit reached\n  Limit: {0}\n{1}", new Object[]{this.limitManager.toString(), this.runtimeStatistics()});
            } else if (this.solver.isFeasible() == Boolean.TRUE) {
                LOGGER.log(Level.INFO, "- Search completed\n{0}", this.runtimeStatistics());
            } else if (this.solver.isFeasible() == Boolean.FALSE) {
                LOGGER.log(Level.INFO, "- Search completed: No solutions\n{0}", this.runtimeStatistics());
            } else {
                LOGGER.log(Level.INFO, "- Search stopped ?\n{1}", this.runtimeStatistics());
            }
        }
    }

    public Boolean nextSolution() {
        if (this.isEncounteredLimit()) {
            return null;
        }
        return this.searchLoop.run();
    }

    @Override
    public void writeSolution(Solution sol) {
        super.writeSolution(sol);
        sol.recordSearchMeasures(this);
    }

    @Override
    public void recordSolution() {
        assert (this.solver.checkSolution().booleanValue());
        super.recordSolution();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "- Solution #{0} found. {1}.", new Object[]{this.getSolutionCount(), this.partialRuntimeStatistics(false)});
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "{0}", this.solver.solutionToString());
            }
        }
    }

    public void postDynamicCut() throws ContradictionException {
    }

    public final IntBranchingTrace pushTrace() {
        ++this.currentTraceIndex;
        if (this.currentTraceIndex >= this.traceStack.length) {
            int newCapacity = this.traceStack.length * 3 / 2 + 1;
            IntBranchingTrace[] tmp = new IntBranchingTrace[newCapacity];
            System.arraycopy(this.traceStack, 0, tmp, 0, this.traceStack.length);
            this.traceStack = tmp;
            this.traceStack[this.currentTraceIndex] = new IntBranchingTrace();
        } else if (this.traceStack[this.currentTraceIndex] == null) {
            this.traceStack[this.currentTraceIndex] = new IntBranchingTrace();
        } else {
            this.traceStack[this.currentTraceIndex].clear();
        }
        return this.traceStack[this.currentTraceIndex];
    }

    public final boolean isTraceEmpty() {
        return this.currentTraceIndex < 0;
    }

    public final IntBranchingTrace getTrace(int index) {
        return this.traceStack[index];
    }

    public final int getCurrentTraceIndex() {
        return this.currentTraceIndex;
    }

    public final int getTraceSize() {
        return this.currentTraceIndex + 1;
    }

    public final IntBranchingTrace popTrace() {
        if (this.currentTraceIndex <= 0) {
            this.currentTraceIndex = -1;
            return null;
        }
        --this.currentTraceIndex;
        return this.traceStack[this.currentTraceIndex];
    }

    public final IntBranchingTrace initialTrace() {
        return this.isTraceEmpty() ? this.initialTrace : this.traceStack[this.currentTraceIndex];
    }

    public final IntBranchingTrace getReusableInitialTrace() {
        return this.initialTrace;
    }

    public final IntBranchingTrace topTrace() {
        return this.isTraceEmpty() ? null : this.traceStack[this.currentTraceIndex];
    }

    public final void clearTrace() {
        this.currentTraceIndex = -1;
    }

    public String runtimeStatistics() {
        return "  Solutions: " + this.getSolutionCount() + '\n' + StringUtils.prettyOnePerLine(this);
    }

    public String partialRuntimeStatistics(boolean logOnSolution) {
        return logOnSolution ? this.getSolutionCount() + " Solutions, " + StringUtils.pretty(this) : StringUtils.pretty(this);
    }

    @Override
    public int getTimeCount() {
        return this.limitManager.getTimeCount();
    }

    @Override
    public int getNodeCount() {
        return this.searchLoop.getNodeCount();
    }

    @Override
    public int getBackTrackCount() {
        return this.searchLoop.getBacktrackCount();
    }

    @Override
    public int getRestartCount() {
        return this.searchLoop.getRestartCount();
    }

    @Override
    public int getFailCount() {
        return this.solver.getPropagationEngine().getFailMeasure().getFailCount();
    }

    public final boolean isEncounteredLimit() {
        return this.encounteredLimit != null;
    }

    public final AbstractGlobalSearchLimit getEncounteredLimit() {
        return this.encounteredLimit;
    }

    public final void setEncounteredLimit(AbstractGlobalSearchLimit encounteredLimit) {
        this.encounteredLimit = encounteredLimit;
    }
}

