/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.constraints.automaton;

import choco.kernel.model.constraints.automaton.LayeredDFA;
import choco.kernel.model.constraints.automaton.LightState;
import choco.kernel.model.constraints.automaton.State;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class LightLayeredDFA {
    protected int[] domSizes;
    protected int[] offsets;
    protected LightState initState;
    protected LightState lastState;
    protected int nbState = 0;
    protected ArrayList[] etatsDeLaCouche;
    protected int nbLevel;

    public int getOffset(int i) {
        return this.offsets[i];
    }

    public LightState getInitState() {
        return this.initState;
    }

    public LightState getLastState() {
        return this.lastState;
    }

    public int getAutomateSize() {
        int tot = 0;
        for (int i = 0; i < this.etatsDeLaCouche.length; ++i) {
            tot += this.etatsDeLaCouche[i].size();
        }
        return tot;
    }

    public boolean isEmpty() {
        return this.etatsDeLaCouche[1].isEmpty();
    }

    public LightLayeredDFA(LayeredDFA automata) {
        this.nbLevel = automata.getNbLevel();
        this.domSizes = new int[this.nbLevel];
        System.arraycopy(automata.domSizes, 0, this.domSizes, 0, this.nbLevel);
        this.domSizes[this.nbLevel - 1] = 0;
        this.offsets = new int[this.nbLevel];
        System.arraycopy(automata.offsets, 0, this.offsets, 0, this.nbLevel);
        this.etatsDeLaCouche = new ArrayList[this.nbLevel];
        for (int i = 0; i < this.etatsDeLaCouche.length; ++i) {
            this.etatsDeLaCouche[i] = new ArrayList();
        }
        Hashtable<State, LightState> ht = new Hashtable<State, LightState>();
        this.nbState = 0;
        for (int i = 0; i < this.nbLevel; ++i) {
            int layerIdx = 0;
            for (int j = 0; j < automata.levelStates[i].size(); ++j) {
                automata.levelStates[i].get(j).setIdx(this.nbState++);
                automata.levelStates[i].get(j).setLayerIdx(layerIdx++);
                LightState nls = new LightState();
                this.etatsDeLaCouche[i].add(nls);
                ht.put(automata.levelStates[i].get(j), nls);
            }
        }
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            State currentState = (State)e.nextElement();
            LightState ff = (LightState)ht.get(currentState);
            ff.init(currentState.convertState(ht));
        }
        this.initState = (LightState)ht.get(automata.initState);
        this.lastState = (LightState)ht.get(automata.lastState);
    }
}

