% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsorth.R
\name{gsorth}
\alias{gsorth}
\title{Gram-Schmidt Orthogonalization of a Matrix}
\usage{
gsorth(y, order, recenter = TRUE, rescale = TRUE, adjnames = TRUE)
}
\arguments{
\item{y}{a numeric matrix or data frame}

\item{order}{if specified, a permutation of the column indices of \code{y}}

\item{recenter}{logical; if \code{TRUE}, the result has same means as the original \code{y}, else means = 0 for cols 2:p}

\item{rescale}{logical; if \code{TRUE}, the result has same sd as original, else, sd = residual sd}

\item{adjnames}{logical; if \code{TRUE}, colnames are adjusted to Y1, Y2.1, Y3.12, ...}
}
\value{
a matrix/data frame with uncorrelated columns
}
\description{
Calculates a matrix with uncorrelated columns using the Gram-Schmidt process
}
\examples{
 set.seed(1234)
 A <- matrix(c(1:60 + rnorm(60)), 20, 3)
 cor(A)
 G <- gsorth(A)
 zapsmall(cor(G))
}

