% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printMatEqn.R
\name{printMatEqn}
\alias{printMatEqn}
\title{Print Matrices or Matrix Operations Side by Side}
\usage{
printMatEqn(..., space = 1, tol = sqrt(.Machine$double.eps), fractions = FALSE)
}
\arguments{
\item{...}{matrices and character operations to be passed and printed to the console. These
can include named arguments, character string operation symbols (e.g., \code{"+"})}

\item{space}{amount of blank spaces to place around operations such as \code{"+"},
\code{"-"}, \code{"="}, etc}

\item{tol}{tolerance for rounding}

\item{fractions}{logical; if \code{TRUE}, try to express non-integers as rational numbers}
}
\value{
NULL; A formatted sequence of matrices and matrix operations is printed to the console
}
\description{
This function is designed to print a collection of matrices, vectors, character strings
and matrix expressions side by side. A typical use is to illustrate matrix equations in a compact and
comprehensible way.
}
\examples{

A <- matrix(c(2, 1, -1,
             -3, -1, 2,
             -2,  1, 2), 3, 3, byrow=TRUE)
x <- c(2, 3, -1)

# provide implicit or explicit labels
printMatEqn(AA = A, "*", xx = x, '=', b = A \%*\% x)
printMatEqn(A, "*", x, '=', b = A \%*\% x)
printMatEqn(A, "*", x, '=', A \%*\% x)

# compare with showEqn
b <- c(4, 2, 1)
printMatEqn(A, x=paste0("x", 1:3),"=", b)
showEqn(A, b)

# decimal example
A <- matrix(c(0.5, 1, 3, 0.75, 2.8, 4), nrow = 2)
x <- c(0.5, 3.7, 2.3)
y <- c(0.7, -1.2)
b <- A \%*\% x - y

printMatEqn(A, "*", x, "-", y, "=", b)
printMatEqn(A, "*", x, "-", y, "=", b, fractions=TRUE)

}
\seealso{
\code{\link{showEqn}}
}
\author{
Phil Chalmers
}
