% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowMedians.R
\name{rowMedians}
\alias{rowMedians}
\alias{colMedians}
\title{Calculates the median for each row (column) in a matrix}
\usage{
rowMedians(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x),
  ..., useNames = TRUE)

colMedians(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x),
  ..., useNames = TRUE)
}
\arguments{
\item{x}{An NxK \code{\link[base]{matrix}} or, if \code{dim.} is specified,
an N * K \code{\link[base]{vector}}.}

\item{rows, cols}{A \code{\link[base]{vector}} indicating subset of rows
(and/or columns) to operate over. If \code{\link[base]{NULL}}, no subsetting
is done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link[base]{NA}}s
are excluded first, otherwise not.}

\item{dim.}{An \code{\link[base]{integer}} \code{\link[base]{vector}} of
length two specifying the dimension of \code{x}, also when not a
\code{\link[base]{matrix}}.}

\item{...}{Not used.}

\item{useNames}{If \code{\link[base:logical]{TRUE}} (default), names
attributes of the result are set, otherwise not.}
}
\value{
Returns a \code{\link[base]{numeric}} \code{\link[base]{vector}} of
length N (K).
}
\description{
Calculates the median for each row (column) in a matrix.
}
\details{
The implementation of \code{rowMedians()} and \code{colMedians()} is
optimized for both speed and memory.  To avoid coercing to
\code{\link[base]{double}}s (and hence memory allocation), there is a
special implementation for \code{\link[base]{integer}} matrices.  That is,
if \code{x} is an \code{\link[base]{integer}} \code{\link[base]{matrix}},
then \code{rowMedians(as.double(x))} (\code{rowMedians(as.double(x))}) would
require three times the memory of \code{rowMedians(x)}
(\code{colMedians(x)}), but all this is avoided.
}
\seealso{
See \code{\link{rowWeightedMedians}()} and
\code{colWeightedMedians()} for weighted medians.
For mean estimates, see \code{\link{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
}
\author{
Henrik Bengtsson, Harris Jaffee
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
