% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrange.R
\name{arrange}
\alias{arrange}
\alias{arrange_row}
\alias{arrange_column}
\title{Re-order rows or columns of a \code{matrixset}}
\usage{
arrange_row(.ms, ..., .by_group = FALSE)

arrange_column(.ms, ..., .by_group = FALSE)
}
\arguments{
\item{.ms}{A \code{matrixset} object}

\item{...}{Name of traits to base sorting upon. Tidy selection is
supported. Use \code{\link[dplyr:desc]{dplyr::desc()}} to sort an annotation in
descending order.}

\item{.by_group}{\code{logical}. Defaults to \code{FALSE} and even if \code{TRUE}, has no
impact on ungrouped margin. Otherwise, grouping
annotation is used first for sorting.}
}
\value{
A \code{matrixset} with re-ordered rows or columns, including updated row or
column meta info.
}
\description{
Orders the rows (\code{\link[=arrange_row]{arrange_row()}}) or columns (\code{\link[=arrange_column]{arrange_column()}}) by
annotation values.

The mechanic is based on sorting the annotation data frame via \code{dplyr}'s
\code{\link[dplyr:arrange]{dplyr::arrange()}}.

This means, for instance, that grouping is ignored by default. You must
either specify the grouping annotation in the sorting annotation, or use
\code{.by_group = TRUE}.

The handling of locales and handling of missing values is also governed by
dplyr's \code{arrange()}.
}
\examples{
ms1 <- remove_row_annotation(student_results, class, teacher)

# this would not work
# remove_row_annotation(row_group_by(student_results, class), class)
}
