% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apply.R
\name{binaryapply_byname}
\alias{binaryapply_byname}
\title{Apply a binary function "by name"}
\usage{
binaryapply_byname(
  FUN,
  a,
  b,
  .FUNdots = NULL,
  match_type = c("all", "matmult", "none"),
  set_rowcoltypes = TRUE,
  .organize = TRUE
)
}
\arguments{
\item{FUN}{a binary function to be applied "by name" to \code{a} and \code{b}.}

\item{a}{the first operand for \code{FUN}.}

\item{b}{the second operand for \code{FUN}.}

\item{.FUNdots}{a list of additional named arguments passed to \code{FUN}.}

\item{match_type}{one of "\code{all}", "\code{matmult}", or "\code{none}".
When both \code{a} and \code{b} are matrices,
"\code{all}" (the default) indicates that
rowtypes of \code{a} must match rowtypes of \code{b} and
coltypes of \code{a} must match coltypes of \code{b}.
If "\code{matmult}",
coltypes of \code{a} must match rowtypes of \code{b}.
If "\code{none}",
neither coltypes nor rowtypes are checked.}

\item{set_rowcoltypes}{tells whether to apply row and column types from \code{a} and \code{b}
to the output.
Set \code{TRUE} (the default) to apply row and column types to the output.
Set \code{FALSE}, to \emph{not} apply row and column types to the output.}

\item{.organize}{a boolean that tells whether or not to automatically
complete \code{a} and \code{b} relative to each other and
sort the rows and columns of the completed matrices.
Normally, this should be \code{TRUE} (the default).
However, if \code{FUN} takes over this responsibility, set to \code{FALSE}.}
}
\value{
the result of applying \code{FUN} "by name" to \code{a} and \code{b}.
}
\description{
If either \code{a} or \code{b} is missing or \code{NULL},
\code{0} is passed to \code{FUN} in its place.
Note that if either \code{a} and \code{b} are lists, elements must be named the same.
The names of list elements of \code{a} are applied to the output.
}
\examples{
productnames <- c("p1", "p2")
industrynames <- c("i1", "i2")
U <- matrix(1:4, ncol = 2, dimnames = list(productnames, industrynames)) \%>\%
  setrowtype("Products") \%>\% setcoltype("Industries")
Y <- matrix(1:4, ncol = 2, dimnames = list(rev(productnames), rev(industrynames))) \%>\%
  setrowtype("Products") \%>\% setcoltype("Industries")
sum_byname(U, Y)
binaryapply_byname(`+`, U, Y)
}
