% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{clean_byname}
\alias{clean_byname}
\title{Cleans (deletes) rows or columns of matrices that contain exclusively \code{clean_value}}
\usage{
clean_byname(a, margin = c(1, 2), clean_value = 0)
}
\arguments{
\item{a}{the matrix to be cleaned}

\item{margin}{the dimension over which cleaning should occur, \code{1} for rows, \code{2} for columns,
or \code{c(1,2)} for both rows and columns. Default is \code{c(1,2)}.}

\item{clean_value}{the undesirable value. Default is \code{0}.

When a row (when \code{margin = 1}) or a column (when \code{margin = 2})
contains exclusively \code{clean_value}, the row or column is deleted from the matrix.}
}
\value{
a "cleaned" matrix, expunged of rows or columns that contain exclusively \code{clean_value}.
}
\description{
Cleans (deletes) rows or columns of matrices that contain exclusively \code{clean_value}
}
\examples{
m <- matrix(c(-20, 1, -20, 2), nrow = 2, dimnames = list(c("r1", "r2"), c("c1", "c2")))
m
m \%>\% clean_byname(margin = 1, clean_value = -20) # Eliminates -20, -20 row
# Nothing cleaned, because no columns contain all 0's (the default clean_value).
m \%>\% clean_byname(margin = 2) 
# Also works with lists
list(m, m) \%>\% clean_byname(margin = 1, clean_value = -20)
# Also works with data frames
DF <- data.frame(m = I(list()))
DF[[1,"m"]] <- m
DF[[2,"m"]] <- m
DF \%>\% clean_byname(margin = 1, clean_value = -20)
m2 <- matrix(c(-20, -20, 0, -20, -20, 0, -20, -20, -20), nrow = 3,
             dimnames = list(c("r1", "r2", "r3"), c("c1", "c2", "c3")) )
m2
clean_byname(m2, margin = c(1,2), clean_value = -20)
DF2 <- data.frame(m2 = I(list()))
DF2[[1, "m2"]] <- m2
DF2[[2, "m2"]] <- m2
DF2 \%>\% clean_byname(margin = c(1, 2), clean_value = -20)
}
