% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maybe.R
\name{maybe_contains}
\alias{maybe_contains}
\title{Check if a maybe value contains a specific value}
\usage{
maybe_contains(.m, value)
}
\arguments{
\item{.m}{A maybe value}

\item{value}{A value to check}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
If the maybe value is a 'Nothing' variant \code{FALSE} will be returned. If it is
a 'Just' variant the contents will be unwrapped and compared to the \code{value}
argument using \code{base::identical}.
}
\examples{
just(1) \%>\% maybe_contains(1)
just("a") \%>\% maybe_contains(1)
nothing() \%>\% maybe_contains(1)
}
