% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{solve_maze}
\alias{solve_maze}
\title{Find a path through a maze}
\usage{
solve_maze(maze, start = "bottomleft", end = "topright")
}
\arguments{
\item{maze}{A \code{\link{maze}} object.}

\item{start}{The coordinates of the starting point. If not provided, this
will be as close as possible to the bottom left corner.}

\item{end}{The coordinates of the end point. If not provided, this will be as
close as possible to the top right corner.}
}
\value{
A \code{matrix} containing the coordinates of the path through the
  maze. Note that the x-coordinate (column index) comes first, so for the
  corresponding indices in the original matrix, these coordinates will need
  to be reversed.
}
\description{
A function that finds the shortest path between points in a maze.
}
\details{
For the \code{start} and \code{end} arguments (as well as the output
  matrix), these coordinates refer to the plotting coordinates, not the
  matrix indices. For plotting, the x-coordinate (column index) is listed
  first, whereas in matrix notation, the row (y-coordinate) is listed first.
}
\examples{
m <- maze(15,15)
p <- solve_maze(m)

plot(m, walls = TRUE)
lines(p, col = 2, lwd = 3)

}
