% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{Boostrap}
\usage{
bootstrap(fun, data, h0, nreps, conf.level = 0.95, verbose = 1)
}
\arguments{
\item{fun}{function to calculate on each sample. This can be a user-defined function that takes in data as a vector and returns a statistic.}

\item{data}{data to use for bootstrapping. Should be a respresentative sample}

\item{h0}{null hypothesis value}

\item{nreps}{number of times to bootstrap}

\item{conf.level}{confidence value}

\item{verbose}{default is 1 which will create a graph. To turn this off use verbose = 0.}
}
\value{
results from boostrapping. A vector of length @param nreps containing each statistic calculated
}
\description{
Boostrap using given data and statistic
}
\examples{
x <- rnorm(100)
bootstrap(mean, x, 0.5, 1000, verbose = 0)
bootstrap(mean, x, 0.5, 1000)
}
