% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{cv.mcen}
\alias{cv.mcen}
\title{Cross validation for mcen function}
\usage{
cv.mcen(x, y, family = "mgaussian", ky = seq(2, 4), gamma_y = seq(0.1,
  5.1, 0.5), nfolds = 10, folds = NULL, cluster_y = NULL, n.cores = 1,
  ...)
}
\arguments{
\item{x}{Matrix set of predictors.}

\item{y}{Matrix set of responses.}

\item{family}{The exponential family the response corresponds to.}

\item{ky}{A vector with the number of possible clusters for y.}

\item{gamma_y}{Set of tuning parameter for clustering penalty in response categories.}

\item{nfolds}{Number of folds used in the cross-validation.}

\item{folds}{A vector of length n, where this identifies what fold of the kfold cross validation each observation belongs to.}

\item{cluster_y}{a priori definition of clusters. If clusters are provided they will remain fixed and are not estimated. Objective function is then convex.}

\item{n.cores}{Number of cores used for parallel processing.}

\item{...}{The variables passed to mcen}
}
\value{
Returns a cv.mcen object. 
\item{models}{A list of mcen objects.}
\item{cv}{Cross validation results.} 
\item{ky}{The same value as the input ky.} 
\item{gamma_y}{The same value as the input gamma_y.}
}
\description{
Cross validation for mcen function
}
\examples{
\donttest{
x <- matrix(rnorm(400),ncol=4)
beta <- beta <- matrix(c(1,1,0,0,0,0,-1,-1,0,0,-1,-1,1,1,0,0),ncol=4)
y <- x\%*\%beta + rnorm(400) 
cv_fit <- cv.mcen(x,y,ky=2)
}
}
\references{
Price, B.S. and Sherwood, B. (2018). A Cluster Elastic Net for Multivariate Regression. arXiv preprint arXiv:1707.03530. \url{http://arxiv-export-lb.library.cornell.edu/abs/1707.03530}.
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>, Brad Price <brad.price@mail.wvu.edu>
}
