% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_dists_new.R
\name{find_dists_new}
\alias{find_dists_new}
\title{Calculate (signed) distances between coordinates}
\usage{
find_dists_new(
  locations,
  locations_new,
  longlat = TRUE,
  origin = 1L,
  return_grid = FALSE,
  ...
)
}
\arguments{
\item{locations}{A matrix or data.frame of 2D points, the first column is
x/longitude, and the second column is y/latitude.}

\item{locations_new}{A matrix or data.frame of 2D points, the first column is
x/longitude, and the second column is y/latitude.}

\item{longlat}{Logical, if TURE Great Circle (WGS84 ellipsoid) distance;
if FALSE, Euclidean distance.}

\item{origin}{Optional; used when \code{longlat} is TRUE. An integer index
indicating the reference location from \code{locations} which will be used as
the origin. Same \code{origin} from \code{find_dists} must be used to ensure
consistancy between outputs from \code{find_dists} and \code{find_dists_new}.}

\item{return_grid}{Logical; used when \code{longlat} is TRUE. If TRUE the mapped
coordinates on a 2D plane for all locations is returned.}

\item{...}{Optional arguments passed to \code{\link[=.find_dists_new]{.find_dists_new()}}.}
}
\value{
A list of distance matrices for all locations. If \code{return_grid} is
TRUE, a list consists of a list of distance matrices for all locations,
the mapped 2D grid for all locations, and the origin is returned.
}
\description{
Calculate (signed) distances between coordinates
}
\details{
\code{locations} and \code{locations_new} must be matrices or data.frames containing
2 columns, first column x/longitude, and second column y/latitude. The row
names of \code{locations} and \code{locations_new} are used as the names of the
locations.

If \code{longlat} is TRUE, the original coordinates are mapped to a 2D Euclidean
plane given the reference location from \code{locations}. First, the Great Circle
(WGS84 ellipsoid) signed distance matrices are calculated, where the original
latitudes are replaced by the the mean of latitudes in \code{locations} to find
the signed longitudinal distances and the original longitudes are replaced by
the the mean of longitudes in \code{locations} to find the signed latitudinal
distances. Then given the index of a reference location \code{origin}, a new set
of coordinates in a 2D plane is generated where the coordinates are
determined by the signed distances between the locations and the reference
location. Finally distance matrices of the new coordinates for all stations
are outputted.
}
\examples{
lon <- c(110, 120, 130)
lat <- c(50, 55, 60)
locations <- cbind(lon, lat)
rownames(locations) <- paste("Site", 1:3)
find_dists(locations)

locations_new <- c(115, 55)
find_dists_new(locations, locations_new)
}
