% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\docType{data}
\name{sim2}
\alias{sim2}
\title{Simulated regime-switching Markov chain Gaussian field}
\format{
\code{sim2}: a list containing a data.frame with 1000 rows and 10 columns,
a list of distances, and a vector of regime labels.
}
\usage{
sim2
}
\description{
Simulated RS-MCGF for 10 locations.
}
\details{
\code{sim2} contains a simulated RS-MCGF for 10 locations. It is simulated with
a regime-switching separable base model. The true parameters for the base
model are: \deqn{\text{Regime 1}: \text{nugget} = 0, c = 0.01, \gamma = 0.5,
a = 0.5, \alpha = 0.2,}
\deqn{\text{Regime 2}: \text{nugget} = 0, c = 0.04, \gamma = 0.5, a = 0.3,
\alpha = 0.9.}
}
\examples{
# Code used to generate `sim2`
\donttest{
library(mcgf)
set.seed(123)
x <- stats::rnorm(10, -110)
y <- stats::rnorm(10, 50)
locations <- cbind(x, y)
h <- find_dists(locations, longlat = TRUE)

# simulate regimes
K <- 2
N <- 1000
lag <- 5

tran_mat <- matrix(rnorm(K^2, mean = 0.06 / (K - 1), sd = 0.01), nrow = K)
diag(tran_mat) <- rnorm(K, mean = 0.94, sd = 0.1)
tran_mat <- sweep(abs(tran_mat), 1, rowSums(tran_mat), `/`)
tran_mat
#            [,1]       [,2]
# [1,] 0.94635675 0.05364325
# [2,] 0.06973429 0.93026571

regime <- rep(NA, N)
regime[1] <- 1

for (n in 2:(N)) {
    regime[n] <- sample(1:K, 1, prob = tran_mat[regime[n - 1], ])
}
table(regime)
# regime
#   1   2
# 567 433

# simulate RS MCGF
par_base1 <- list(
    par_s = list(nugget = 0, c = 0.001, gamma = 0.5),
    par_t = list(a = 0.5, alpha = 0.2)
)

par_base2 <- list(
    par_s = list(nugget = 0, c = 0.004, gamma = 0.5),
    par_t = list(a = 0.3, alpha = 0.9)
)

sim2 <- mcgf_rs_sim(
    N = N, label = regime,
    base_ls = list("sep"), lagrangian_ls = list("none"),
    par_base_ls = list(par_base1, par_base2),
    lambda_ls = list(0.1, 0.3),
    lag_ls = list(lag, lag),
    dists_ls = list(h, h)
)
sim2 <- sim2[-c(1:(lag + 1)), ]
rownames(sim2) <- 1:nrow(sim2)

sim2 <- list(
    data = sim2[, -1], locations = locations, dists = h,
    label = sim2[, 1]
)
}
}
\seealso{
Other (simulated) datasets: 
\code{\link{sim1}},
\code{\link{sim3}},
\code{\link{wind}}
}
\concept{(simulated) datasets}
\keyword{datasets}
