% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_jagscode.R
\encoding{UTF-8}
\name{get_jagscode}
\alias{get_jagscode}
\title{Make JAGS code for Multiple Change Point model}
\usage{
get_jagscode(prior, ST, formula_str, arma_order, family, sample)
}
\arguments{
\item{prior}{Named list. Names are parameter names (\code{cp_i}, \code{int_i}, \code{xvar_i},
`sigma``) and the values are either
\itemize{
\item A JAGS distribution (e.g., \code{int_1 = "dnorm(0, 1) T(0,)"}) indicating a
conventional prior distribution. Uninformative priors based on data
properties are used where priors are not specified. This ensures good
parameter estimations, but it is a questionable for hypothesis testing.
\code{mcp} uses SD (not precision) for dnorm, dt, dlogis, etc. See
details. Change points are forced to be ordered through the priors using
truncation, except for uniform priors where the lower bound should be
greater than the previous change point, \code{dunif(cp_1, MAXX)}.
\item A numerical value (e.g., \code{int_1 = -2.1}) indicating a fixed value.
\item A model parameter name (e.g., \code{int_2 = "int_1"}), indicating that this parameter is shared -
typically between segments. If two varying effects are shared this way,
they will need to have the same grouping variable.
\item A scaled Dirichlet prior is supported for change points if they are all set to
\verb{cp_i = "dirichlet(N)} where \code{N} is the alpha for this change point and
\code{N = 1} is most often used. This prior is less informative about the
location of the change points than the default uniform prior, but it
samples less efficiently, so you will often need to set \code{iter} higher.
It is recommended for hypothesis testing and for the estimation of more
than 5 change points. \href{https://lindeloev.github.io/mcp/articles/priors.html}{Read more}.
}}

\item{ST}{Segment table. Returned by \code{get_segment_table()}.}

\item{formula_str}{String. The formula string returned by \code{build_formula_str}.}

\item{arma_order}{Positive integer. The autoregressive order.}

\item{family}{One of \code{gaussian()}, \code{binomial()}, \code{bernoulli()}, or \code{poission()}.
Only default link functions are currently supported.}

\item{sample}{One of
\itemize{
\item \code{"post"} (default): Sample the posterior.
\item \code{"prior"}: Sample only the prior. Plots, summaries, etc. will
use the prior. This is useful for prior predictive checks.
\item \code{"both"}: Sample both prior and posterior. Plots, summaries, etc.
will default to using the posterior. The prior only has effect when doing
Savage-Dickey density ratios in \code{\link{hypothesis}}.
\item \code{"none"} or \code{FALSE}: Do not sample. Returns an mcpfit
object without sample. This is useful if you only want to check
prior strings (fit$prior), the JAGS model (fit$jags_code), etc.
}}
}
\value{
String. A JAGS model.
}
\description{
Make JAGS code for Multiple Change Point model
}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
\keyword{internal}
