% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_factor}
\alias{h_factor}
\title{Factor Variable Per Levels}
\usage{
h_factor(df, var, levels = NULL, ...)
}
\arguments{
\item{df}{(\code{data.frame})\cr input data.}

\item{var}{(\code{string})\cr variable to factor.}

\item{levels}{(\code{vector})\cr a character vector of known levels.}

\item{...}{other arguments to be passed to \code{\link[=factor]{factor()}}.}
}
\value{
A factor variable
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper function factor inputs in order of appearance, or per the levels that you provide.
}
\examples{
df <- data.frame(a = c("aa", "a", "aa"))
h_factor(df, var = "a")
h_factor(df, var = "a", levels = c("aa", "a"))
}
