% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_mc.R
\name{expect_mc_iid_ks}
\alias{expect_mc_iid_ks}
\title{Test iid samples for correct cdf using KS test}
\usage{
expect_mc_iid_ks(object, cdf, control = NULL)
}
\arguments{
\item{object}{A function taking one argument - that generates n univariate iid samples.}

\item{cdf}{A univariate cumulative distribution function, taking exactly one argument.}

\item{control}{a list controlling the algorithm
\itemize{
\item n number of samples to be taken in the first step. Default: 1e3
\item maxseqsteps: Number of sequential attempts to use. Default: 7.
\item incn: Factor by which to multiply n from the second  sequential attempt onwards. Default: 4.
\item level: bound on the type I error, ie the probability of wrongly rejecting a sampler with the correct distribution. Default: 1e-5.
\item debug: If positive  then debug information will be printed via 'message()'. Default: 0.
}}
}
\value{
The first argument, invisibly, to allow chaining of expectations.
}
\description{
Test if samples are behaving like an iid sample from a given CDF
via the KS test and a sequential approach. Only works for
continuous CDFs. Will report a warning if values are discrete
}
\examples{
   sampler <- function(n) rnorm(n)
   expect_mc_iid_ks(sampler, pnorm)
}
