% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{plotScores.pca}
\alias{plotScores.pca}
\title{Scores plot for PCA model}
\usage{
\method{plotScores}{pca}(
  obj,
  comp = c(1, 2),
  type = "p",
  show.axes = TRUE,
  show.legend = TRUE,
  res = obj$res,
  ...
)
}
\arguments{
\item{obj}{a PCA model (object of class \code{pca})}

\item{comp}{a value or vector with several values - number of components to show the plot for}

\item{type}{type of the plot ("p", "l", "b", "h")}

\item{show.axes}{logical, show or not a axes lines crossing origin (0,0)}

\item{show.legend}{logical, show or not a legend on the plot}

\item{res}{list with result objects to show the variance for}

\item{...}{other plot parameters (see \code{mdaplotg} for details)}
}
\description{
Shows a scores plot for selected components.
}
\details{
If plot is created only for one result object (e.g. calibration set), then the behaviour and
all settings for the scores plot are identical to \code{\link{plotScores.ldecomp}}. In this case
you can show scores as a scatter, line or bar plot for any number of components.

Otherwise (e.g. if model contains results for calibration and test set) the plot is a group
plot created using \code{\link{mdaplotg}} method and only scatter plot can be used.

See examples in help for \code{\link{pca}} function.
}
