% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_as_na.R
\name{recode_as_na}
\alias{recode_as_na}
\title{Recode a value as NA}
\usage{
recode_as_na(
  df,
  value = NULL,
  subset_df = FALSE,
  tidy = FALSE,
  subset_cols = NULL,
  pattern_type = NULL,
  pattern = NULL,
  ...
)
}
\arguments{
\item{df}{A data.frame object for which recoding is to be done.}

\item{value}{The value to convert to `NA`. We can for instance change "n/a" to `NA` or any other value.}

\item{subset_df}{Logical. Use only specific columns? Defaults to FALSE. All "value"s everywhere are "recoded".}

\item{tidy}{If set to TRUE,
then one can provide additional arguments to match specific patterns using pattern and pattern_type}

\item{subset_cols}{Character. If subset_df is TRUE, then this provides the columns for which changes are required.}

\item{pattern_type}{One of contains, starts_with or ends_with. Used only if subset_cols is set to tidy.}

\item{pattern}{A character pattern to match}

\item{...}{Other arguments to other functions}
}
\value{
An object of the same class as x with values changed to `NA`.
}
\description{
This provides a convenient way to convert a number/value that should indeed be an
"NA" to "NA". In otherwords, it converts a value to R's recognized NA.
}
\examples{
dummy_test <- data.frame(ID = c("A","B","B","A"),
values = c("n/a",NA,"Yes","No"))
# Replace n/a with "NA". We assume n/a is treated as missing(subjective)
recode_as_na(dummy_test,"n/a")
# Recode only at specific columns
another_dummy <- data.frame(ID = 1:5, Subject = 7:11,
Change = c("missing", "n/a", 2:4 ))
# Change missing and n/a to NA only for the column named Change.
recode_as_na(another_dummy, subset_df = TRUE,
subset_cols = "Change", value = c("n/a",
                              "missing"))
 recode_as_na(airquality, subset_df = TRUE,
tidy=TRUE, pattern_type="starts_with",
pattern="Solar")
}
