/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.utils.MathUtils;
import multidendrograms.core.utils.SmartAxis;
import multidendrograms.utils.NumberUtils;

public class ToNewick {
    private Dendrogram root;
    private boolean isUniformOrigin;
    private double dendroBottomHeight;
    private PrintWriter printWriter;

    public ToNewick(Dendrogram dendrogram, boolean bl) {
        this.root = dendrogram;
        this.isUniformOrigin = bl;
        SmartAxis smartAxis = new SmartAxis(dendrogram, bl);
        this.dendroBottomHeight = dendrogram.isDistanceBased ? smartAxis.smartMin() : smartAxis.smartMax();
    }

    public void saveAsNewick(String string) throws IOException {
        File file = new File(string);
        FileWriter fileWriter = new FileWriter(file);
        this.printWriter = new PrintWriter(fileWriter);
        this.showCluster(this.root, this.root.getRootBottomHeight());
        this.printWriter.print(";");
        this.printWriter.close();
    }

    private void showCluster(Dendrogram dendrogram, double d) {
        double d2;
        int n = dendrogram.numberOfSubclusters();
        double d3 = dendrogram.getRootBottomHeight();
        if (n == 1) {
            String string = this.adaptName(dendrogram.getLabel());
            this.printWriter.print(string);
            d2 = Double.isNaN(d3) || this.isUniformOrigin ? this.dendroBottomHeight : d3;
        } else {
            d2 = d3;
            this.printWriter.print("(");
            for (int i = 0; i < n; ++i) {
                this.showCluster(dendrogram.getSubcluster(i), d2);
                if (i >= n - 1) continue;
                this.printWriter.print(",");
            }
            this.printWriter.print(")");
        }
        this.printClusterLength(d, d2);
    }

    private String adaptName(String string) {
        String string2 = new String(string);
        string2 = string2.replace(' ', '_');
        string2 = string2.replace('\'', '\"');
        string2 = string2.replace(':', '|');
        string2 = string2.replace(';', '|');
        string2 = string2.replace(',', '|');
        string2 = string2.replace('(', '{');
        string2 = string2.replace(')', '}');
        string2 = string2.replace('[', '{');
        string2 = string2.replace(']', '}');
        return string2;
    }

    private void printClusterLength(double d, double d2) {
        int n = this.root.precision;
        double d3 = this.root.isDistanceBased ? MathUtils.round(d, n) - MathUtils.round(d2, n) : MathUtils.round(d2, n) - MathUtils.round(d, n);
        if ((d3 = MathUtils.round(d3, n)) > 0.0) {
            String string = NumberUtils.format(d3, n);
            this.printWriter.print(":" + string);
        }
    }
}

