/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram.eps;

import multidendrograms.definitions.Config;
import multidendrograms.dendrogram.eps.EpsPlot;
import multidendrograms.dendrogram.eps.EpsUtils;
import multidendrograms.forms.children.DendrogramPanel;

public class EpsExporter {
    private static final String EPS_PROLOG = "./ini/eps_prolog.txt";
    private static final String EPS_CREATOR = "./ini/eps_prolog.txt";
    private static final String EPS_ORIENTATION = "Portrait";
    private final EpsPlot dendroEpsPlot;
    private final int xmin;
    private final int xmax;
    private final int ymin;
    private final int ymax;

    public EpsExporter(Config config, DendrogramPanel dendrogramPanel, String string) {
        this.xmin = 72;
        this.ymin = 72;
        this.xmax = dendrogramPanel.getWidth() + 72;
        this.ymax = dendrogramPanel.getHeight() + 72;
        new EpsUtils(this.xmin, this.ymin, this.xmax, this.ymax);
        this.dendroEpsPlot = new EpsPlot(dendrogramPanel, config, this.xmax, this.ymax);
        this.writeEPS(string);
    }

    public void writeEPS(String string) {
        EpsUtils.open(string);
        EpsUtils.writeComments("./ini/eps_prolog.txt", EPS_ORIENTATION);
        EpsUtils.writeProlog("./ini/eps_prolog.txt");
        this.writeBodyIni();
        EpsUtils.writeBodyEnd();
        EpsUtils.close();
    }

    public void writeBodyIni() {
        EpsUtils.writeLine("");
        EpsUtils.writeLine("%%Page: 1 1");
        EpsUtils.writeLine(EpsUtils.setLineWidth(1.0f));
        EpsUtils.writeLine("[] 0 setdash");
        this.dendroEpsPlot.drawDendro();
    }
}

