/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.children;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import multidendrograms.definitions.Config;
import multidendrograms.definitions.Formats;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.dendrogram.Clipping;
import multidendrograms.dendrogram.Scaling;
import multidendrograms.dendrogram.figures.Axis;
import multidendrograms.dendrogram.figures.AxisLabel;
import multidendrograms.dendrogram.figures.Band;
import multidendrograms.dendrogram.figures.Line;
import multidendrograms.dendrogram.figures.Node;
import multidendrograms.dendrogram.figures.NodeLabel;
import multidendrograms.forms.PrincipalDesk;
import multidendrograms.forms.XYBox;
import multidendrograms.forms.children.DendrogramTree;
import multidendrograms.initial.Language;
import multidendrograms.initial.LogManager;
import multidendrograms.types.PlotType;

public class DendrogramPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ActionListener al;
    private JPopupMenu menu;
    private Config cfg = null;
    private LinkedList<Node> nodesList;
    private LinkedList<Line> linesList;
    private LinkedList<Band> bandsList;
    protected DendrogramPanel dendroPanel;
    private final PrincipalDesk frm;

    public DendrogramPanel(PrincipalDesk principalDesk) {
        this.frm = principalDesk;
        this.initComponentsMenu();
        this.dendroPanel = this;
    }

    private void initComponentsMenu() {
        this.al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(Language.getLabel(96))) {
                    try {
                        BufferedImage bufferedImage = DendrogramPanel.this.draw();
                        DendrogramPanel.this.frm.savePicture(bufferedImage, "jpg", DendrogramPanel.this.cfg);
                    }
                    catch (Exception exception) {
                        LogManager.LOG.throwing("DendrogramPanel", "initComponentsMenu()", exception);
                        String string = Language.getLabel(81);
                        JOptionPane.showInternalMessageDialog(DendrogramPanel.this.frm.getPanDesk(), string, "MultiDendrograms", 0);
                    }
                } else if (actionEvent.getActionCommand().equals(Language.getLabel(97))) {
                    try {
                        BufferedImage bufferedImage = DendrogramPanel.this.draw();
                        DendrogramPanel.this.frm.savePicture(bufferedImage, "png", DendrogramPanel.this.cfg);
                    }
                    catch (Exception exception) {
                        LogManager.LOG.throwing("DendrogramPanel", "initComponentsMenu()", exception);
                        String string = Language.getLabel(81);
                        JOptionPane.showInternalMessageDialog(DendrogramPanel.this.frm.getPanDesk(), string, "MultiDendrograms", 0);
                    }
                } else if (actionEvent.getActionCommand().equals(Language.getLabel(95))) {
                    try {
                        new DendrogramTree(DendrogramPanel.this.cfg);
                    }
                    catch (Exception exception) {
                        LogManager.LOG.throwing("DendrogramPanel", "initComponentsMenu()", exception);
                        String string = Language.getLabel(76);
                        JOptionPane.showMessageDialog(DendrogramPanel.this.frm.getPanDesk(), string, "MultiDendrograms", 0);
                    }
                } else if (actionEvent.getActionCommand().equals(Language.getLabel(98))) {
                    try {
                        DendrogramPanel.this.frm.saveTXT(DendrogramPanel.this.cfg);
                    }
                    catch (Exception exception) {
                        LogManager.LOG.throwing("DendrogramPanel", "initComponentsMenu()", exception);
                        String string = Language.getLabel(81);
                        JOptionPane.showInternalMessageDialog(DendrogramPanel.this.frm.getPanDesk(), string, "MultiDendrograms", 0);
                    }
                } else if (actionEvent.getActionCommand().equals(Language.getLabel(87))) {
                    try {
                        DendrogramPanel.this.frm.saveNewick(DendrogramPanel.this.cfg);
                    }
                    catch (Exception exception) {
                        LogManager.LOG.throwing("DendrogramPanel", "initComponentsMenu()", exception);
                        String string = Language.getLabel(81);
                        JOptionPane.showInternalMessageDialog(DendrogramPanel.this.frm.getPanDesk(), string, "MultiDendrograms", 0);
                    }
                } else if (actionEvent.getActionCommand().equals(Language.getLabel(79))) {
                    try {
                        DendrogramPanel.this.frm.saveJson(DendrogramPanel.this.cfg);
                    }
                    catch (Exception exception) {
                        LogManager.LOG.throwing("DendrogramPanel", "initComponentsMenu()", exception);
                        String string = Language.getLabel(81);
                        JOptionPane.showInternalMessageDialog(DendrogramPanel.this.frm.getPanDesk(), string, "MultiDendrograms", 0);
                    }
                } else if (actionEvent.getActionCommand().equals(Language.getLabel(99))) {
                    try {
                        DendrogramPanel.this.frm.savePostScript(DendrogramPanel.this.dendroPanel, DendrogramPanel.this.cfg);
                    }
                    catch (Exception exception) {
                        LogManager.LOG.throwing("DendrogramPanel", "initComponentsMenu()", exception);
                        String string = Language.getLabel(81);
                        JOptionPane.showInternalMessageDialog(DendrogramPanel.this.frm.getPanDesk(), string, "MultiDendrograms", 0);
                    }
                } else if (actionEvent.getActionCommand().equals(Language.getLabel(116))) {
                    try {
                        DendrogramPanel.this.frm.saveUltrametricTxt(DendrogramPanel.this.cfg);
                    }
                    catch (Exception exception) {
                        LogManager.LOG.throwing("DendrogramPanel", "initComponentsMenu()", exception);
                        String string = Language.getLabel(81);
                        JOptionPane.showInternalMessageDialog(DendrogramPanel.this.frm.getPanDesk(), string, "MultiDendrograms", 0);
                    }
                } else if (actionEvent.getActionCommand().equals(Language.getLabel(111))) {
                    try {
                        DendrogramPanel.this.frm.saveDendrogramMeasures(DendrogramPanel.this.cfg);
                    }
                    catch (Exception exception) {
                        LogManager.LOG.throwing("DendrogramPanel", "initComponentsMenu()", exception);
                        String string = Language.getLabel(81);
                        JOptionPane.showInternalMessageDialog(DendrogramPanel.this.frm.getPanDesk(), string, "MultiDendrograms", 0);
                    }
                } else if (actionEvent.getActionCommand().equals(Language.getLabel(117))) {
                    DendrogramPanel.this.frm.showDendrogramMeasures(DendrogramPanel.this.cfg);
                }
            }
        };
        this.menu = new JPopupMenu();
        JMenuItem jMenuItem = Formats.getFormattedMenuItem(Language.getLabel(117));
        JMenuItem jMenuItem2 = Formats.getFormattedMenuItem(Language.getLabel(95));
        JMenuItem jMenuItem3 = Formats.getFormattedMenuItem(Language.getLabel(111));
        JMenuItem jMenuItem4 = Formats.getFormattedMenuItem(Language.getLabel(116));
        JMenuItem jMenuItem5 = Formats.getFormattedMenuItem(Language.getLabel(98));
        JMenuItem jMenuItem6 = Formats.getFormattedMenuItem(Language.getLabel(87));
        JMenuItem jMenuItem7 = Formats.getFormattedMenuItem(Language.getLabel(79));
        JMenuItem jMenuItem8 = Formats.getFormattedMenuItem(Language.getLabel(96));
        JMenuItem jMenuItem9 = Formats.getFormattedMenuItem(Language.getLabel(97));
        JMenuItem jMenuItem10 = Formats.getFormattedMenuItem(Language.getLabel(99));
        jMenuItem.addActionListener(this.al);
        jMenuItem2.addActionListener(this.al);
        jMenuItem3.addActionListener(this.al);
        jMenuItem4.addActionListener(this.al);
        jMenuItem5.addActionListener(this.al);
        jMenuItem6.addActionListener(this.al);
        jMenuItem7.addActionListener(this.al);
        jMenuItem8.addActionListener(this.al);
        jMenuItem9.addActionListener(this.al);
        jMenuItem10.addActionListener(this.al);
        this.menu.add(jMenuItem);
        this.menu.add(jMenuItem2);
        this.menu.addSeparator();
        this.menu.add(jMenuItem3);
        this.menu.add(jMenuItem4);
        this.menu.add(jMenuItem5);
        this.menu.add(jMenuItem6);
        this.menu.add(jMenuItem7);
        this.menu.addSeparator();
        this.menu.add(jMenuItem8);
        this.menu.add(jMenuItem9);
        this.menu.add(jMenuItem10);
        this.enableEvents(16L);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void setConfig(Config config) {
        this.cfg = config;
    }

    public LinkedList<Node> getNodesList() {
        return this.nodesList;
    }

    public LinkedList<Line> getLinesList() {
        return this.linesList;
    }

    public LinkedList<Band> getBandsList() {
        return this.bandsList;
    }

    public void setNodesList(LinkedList<Node> linkedList) {
        this.nodesList = linkedList;
        LogManager.LOG.finest("Number of nodes: (" + linkedList.size() + ")");
    }

    public void setLinesList(LinkedList<Line> linkedList) {
        this.linesList = linkedList;
        LogManager.LOG.finest("Number of nodes: (" + linkedList.size() + ")");
    }

    public void setBandsList(LinkedList<Band> linkedList) {
        this.bandsList = linkedList;
        LogManager.LOG.finest("Number of nodes: (" + linkedList.size() + ")");
    }

    @Override
    public void update(Graphics graphics) {
        super.update(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawDendro(graphics2D);
    }

    private BufferedImage draw() {
        double d = this.getSize().getWidth();
        double d2 = this.getSize().getHeight();
        BufferedImage bufferedImage = new BufferedImage((int)d, (int)d2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, (int)d, (int)d2);
        this.drawDendro(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void drawDendro(Graphics2D graphics2D) {
        double d = this.getSize().getWidth();
        double d2 = this.getSize().getHeight();
        XYBox xYBox = new XYBox(this.cfg, d, d2);
        Scaling scaling = xYBox.getScalingDendrogram();
        Scaling scaling2 = xYBox.getScalingBullets();
        Scaling scaling3 = xYBox.getScalingAxis();
        Scaling scaling4 = xYBox.getScalingAxisLabels();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.scale(1.0, -1.0);
        graphics2D.setBackground(Color.GREEN);
        this.drawDendrogram(graphics2D, scaling);
        this.drawBullets(graphics2D, scaling2, scaling);
        this.drawNodesNames(graphics2D, scaling);
        this.drawAxis(graphics2D, scaling3);
        this.drawAxisLabels(graphics2D, scaling4);
    }

    private void drawDendrogram(Graphics2D graphics2D, Scaling scaling) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        Clipping clipping = new Clipping(this.cfg.getProximityType(), this.cfg.getAxisMinValue(), this.cfg.getAxisMaxValue());
        for (Band object : clipping.clipBands(this.bandsList)) {
            object.setDendrogramOrientation(this.cfg.getDendrogramOrientation());
            object.setScaling(scaling);
            object.setColor(settingsInfo.getBandColor());
            object.setFilled(true);
            object.draw(PlotType.PANEL, graphics2D);
        }
        for (Line line : clipping.clipLines(this.linesList)) {
            line.setDendrogramOrientation(this.cfg.getDendrogramOrientation());
            line.setScaling(scaling);
            line.draw(PlotType.PANEL, graphics2D);
        }
        for (Band band : clipping.clipBands(this.bandsList)) {
            band.setDendrogramOrientation(this.cfg.getDendrogramOrientation());
            band.setScaling(scaling);
            band.setColor(settingsInfo.getBandColor());
            band.setFilled(false);
            band.draw(PlotType.PANEL, graphics2D);
        }
    }

    private void drawBullets(Graphics2D graphics2D, Scaling scaling, Scaling scaling2) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        if (settingsInfo.getNodeRadius() > 0) {
            for (Node node : this.nodesList) {
                node.setDendrogramOrientation(this.cfg.getDendrogramOrientation());
                node.setScaling(scaling);
                node.setScalingDendrogram(scaling2);
                node.draw(PlotType.PANEL, graphics2D);
            }
        }
    }

    private void drawNodesNames(Graphics2D graphics2D, Scaling scaling) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        if (settingsInfo.isNodeNameVisible()) {
            NodeLabel nodeLabel = new NodeLabel(this.nodesList, settingsInfo, scaling);
            nodeLabel.draw(PlotType.PANEL, graphics2D);
        }
    }

    private void drawAxis(Graphics2D graphics2D, Scaling scaling) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        if (settingsInfo.isAxisVisible() && this.cfg.getAxisTicks() > 0) {
            Axis axis = new Axis(settingsInfo, scaling);
            axis.draw(PlotType.PANEL, graphics2D);
        }
    }

    private void drawAxisLabels(Graphics2D graphics2D, Scaling scaling) {
        SettingsInfo settingsInfo = this.cfg.getSettingsInfo();
        if (settingsInfo.isAxisLabelVisible() && this.cfg.getAxisTicks() > 0) {
            AxisLabel axisLabel = new AxisLabel(settingsInfo, scaling);
            axisLabel.draw(PlotType.PANEL, graphics2D);
        }
    }
}

