% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdgc.R
\name{get_mdgc}
\alias{get_mdgc}
\title{Get mdgc Object}
\usage{
get_mdgc(dat)
}
\arguments{
\item{dat}{\code{\link{data.frame}} with continuous, multinomial, ordinal, and binary
variables.}
}
\value{
An object of class \code{mdgc}. It has the following elements:
\item{lower,upper,code,multinomial,idx_non_zero_mean}{arguments to pass to
\code{\link{get_mdgc_log_ml}}.}
\item{margs}{functions to get \code{lower} and \code{upper} bounds for each
column of \code{dat}.}
\item{reals,bins,ords}{indices of continuous, binary, and ordinal variables,
respectively.}
\item{truth}{the numeric version of \code{dat}.}
\item{means}{starting values for the non-zero mean terms
(see e.g. \code{\link{mdgc_fit}}).}
}
\description{
Creates a mdgc object which is needed for estimation of the
covariance matrix and the mean vector and to perform imputation.
}
\details{
It is important to use appropriate classes for the \code{\link{data.frame}}
columns:

\itemize{
  \item{Continuous variables: }{should be \code{\link{numeric}}s.}
  \item{Binary variables: }{should be \code{\link{logical}}s.}
  \item{Multinomial variables: }{should be \code{\link{factor}}s.}
  \item{Ordinal variables: }{should be \code{\link{ordered}}.}
}
}
\examples{
# randomly mask data
set.seed(11)
masked_data <- iris
masked_data[matrix(runif(prod(dim(iris))) < .10, NROW(iris))] <- NA

# use the functions in the package
library(mdgc)
obj <- get_mdgc(masked_data)
class(obj)

}
\seealso{
\code{\link{get_mdgc_log_ml}}, \code{\link{mdgc_start_value}}
}
