% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizumat.R
\name{vizu.mat}
\alias{vizu.mat}
\title{Visualize matrix data in a form of a heatmap}
\usage{
vizu.mat(matrix.object, title = "", base_size = 12, limits = NULL,
  colors.palette = NULL, adjust.limits = TRUE, adjust.colors = TRUE,
  rotate.x.labels = TRUE, uniform.labes = FALSE, clear.x.label = FALSE,
  clear.y.label = FALSE, clear.labels = TRUE, geom_tile.colour = "grey")
}
\arguments{
\item{matrix.object}{data matrix}

\item{title}{plot title}

\item{base_size}{\code{ggplot2} theme \code{base_size} parameter value}

\item{limits}{2-element vector of color legend scale limit values}

\item{colors.palette}{color palette used as an argument in the 
\code{scale_fill_gradient} \code{ggplot2} expression}

\item{adjust.limits}{logical whether or not to adjust color legend scale limits 
in a way described in Details section
(if FALSE, default \code{ggplot2} options are applied)}

\item{adjust.colors}{logical whether or not to adjust plot color selection 
in a way described in Details section
(if FALSE, default \code{ggplot2} options are applied)}

\item{rotate.x.labels}{logical whether or not to rotate x-axis labels by 90 degrees}

\item{uniform.labes}{logical whether or not to add "generic" column and rows labeling
("c1", "c2", ... for columns and "r1", "r2", ... for rows);
might be useful i.e. if the matrix we pass to function has 
some really long colnames and rownames assigned}

\item{clear.x.label}{logical whether or not to clear x-axis labels}

\item{clear.y.label}{logical whether or not to clear y-axis labels}

\item{clear.labels}{logical whether or not to clear both x- and y-axis labels}

\item{geom_tile.colour}{\code{ggplot2} parameter defining the color of blocks grid}
}
\value{
\code{NULL}
}
\description{
Produces convenient matrix data visualization in the form of a heatmap, with
the use of \code{ggplot2} library.
}
\details{
Designed to provide 
decent visualization output with low number of input arguments that a user has to define.
Allows for further output plot adjustments that one often seeks for, including
adding a title, font size change, axis label clearing, axis label rotating etc.

By default, adjusts color scale based on matrix values: 
outputs 1-color plot for a matrix input which values are of one sign and
outputs 2-color plot for a matrix input which values are of both 
negative and positive values. 

By default, adjusts the plot legend color so as it is: 
white-red for a data matrix with only positive values,  
blue-white for a data matrix with only negative values,
blue-white-red for a data matrix with both positive and negative values.

By default, adjusts the color legend scale so as 
it starts from 0 for matrix values with one sign or is symmetric for matrix 
with both negative and positive values.

Does not return any object as it calls a \code{ggplot::plot} method itself.
}
\examples{
set.seed(123)
set.seed(123)
n <- 100
p <- 50
colnames <- replicate(p, paste0(sample(LETTERS, 5), collapse = ""))
rownames <- replicate(n, paste0(sample(LETTERS, 5), collapse = ""))
mat1 <- matrix(rnorm(n*p), nrow = n, ncol = p, dimnames = list(rownames, colnames))
vizu.mat(mat1, "mat1")
vizu.mat(mat1, "mat1 with uniformed labels", uniform.labes = TRUE, clear.labels = FALSE)
vizu.mat(mat1, "mat1 with predefined scale limits\\nand smaller font size", 
limits = c(-4, 4), base_size = 5)
vizu.mat(cor(mat1), "column correlation matrix", geom_tile.colour = "white")

}

