% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{run_algos}
\alias{run_algos}
\alias{run_algos.list}
\alias{run_algos.default}
\title{Run Multiple Algorithms}
\usage{
run_algos(data, algos, dataframe = T, non_dpa = "skip", ...)

\method{run_algos}{list}(data, algos, dataframe = T, non_dpa = "skip",
  ...)

\method{run_algos}{default}(data, algos, dataframe = T,
  non_dpa = "skip", ...)
}
\arguments{
\item{data}{Required input dataset. Note that the dataset must satisfy the
dataset requirements for each algorithm specified (parameter \code{df}). An
\code{mds} times series object (class \code{mds_ts}) is a natural fit.}

\item{algos}{Input list of algorithms to run. Must be a list generated by
\code{\link{define_algos}}.}

\item{dataframe}{Logical on whether to output results as a
\code{mdsstat_tests} data frame. If \code{FALSE}, will output as a list of
\code{mdsstat_test} lists.

Default: \code{TRUE}}

\item{non_dpa}{What to do when input \code{data} is not prepared for
disproportionality analysis (DPA) data. Three values are accepted:
\code{"skip"}, \code{"warn"}, and \code{"stop"}. \code{"skip"} skips the
DPA test without warnings or errors. \code{"warn"} outputs a warning and
then skips the DPA test. \code{"stop"} stops the function call.

Default: \code{"skip"}}

\item{...}{Further arguments for future work.}
}
\value{
A \code{mdsstat_tests} data frame or list of \code{mdsstat_test}
lists with the results of the algorithm runs.
}
\description{
Run a multiple number of \code{mdsstat} algorithms on a single input dataset.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: Run algorithms on a list of time series

\item \code{default}: Run algorithms on a single time series
}}

\examples{
data <- mds_ts[[1]]
data$rate <- data$nA / data$exposure
x <- list(prr=list(),
  xbar=list(),
  xbar=list(ts_event=c(Rate="rate"), we_rule=2),
  poisson_rare=list(p_rate=0.3))
algos <- define_algos(x)
run_algos(data, algos)
run_algos(data, algos, FALSE)
}
