% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional.R
\name{poisson_rare}
\alias{poisson_rare}
\alias{poisson_rare.mds_ts}
\alias{poisson_rare.default}
\title{Poisson for Rare Events}
\usage{
poisson_rare(df, ...)

\method{poisson_rare}{mds_ts}(df, ts_event = c(Count = "nA"), analysis_of = NA, ...)

\method{poisson_rare}{default}(
  df,
  analysis_of = NA,
  eval_period = NULL,
  zero_rate = 2/3,
  p_rate = 0.2,
  p_crit = 0.05,
  ...
)
}
\arguments{
\item{df}{Required input data frame of class \code{mds_ts} or, for generic
usage, any data frame with the following columns:
\describe{
  \item{time}{Unique times of class \code{Date}}
  \item{event}{Either the event count or rate of class \code{numeric}}
}}

\item{...}{Further arguments passed onto \code{poisson_rare} methods}

\item{ts_event}{Required if \code{df} is of class \code{mds_ts}. Named string
indicating the variable corresponding to the event count or rate. Rate must
be calculated in a separate column in \code{df} as it is not calculated by
default. The name of the string is an English description of what was
analyzed.

Default: \code{c("Count"="nA")} corresponding to the event count column in
\code{mds_ts} objects. Name is generated from \code{mds_ts} metadata.

Example: \code{c("Rate of Bone Filler Events in Canada"="rate")}}

\item{analysis_of}{Optional string indicating the English description of what
was analyzed. If specified, this will override the name of the
\code{ts_event} string parameter.

Default: \code{NA} indicates no English description for plain \code{df}
data frames, or \code{ts_event} English description for \code{df} data frames
of class \code{mds_ts}.

Example: \code{"Rate of bone cement leakage"}}

\item{eval_period}{Optional positive integer indicating the number of unique
times counting in reverse chronological order to assess.

Default: \code{NULL} considers all times in \code{df}.}

\item{zero_rate}{Required minimum proportion of \code{event}s in \code{df}
(constrained by \code{eval_period}) containing zeroes for this algorithm to
run.

Default: \code{2/3} requires a minimum of 2/3 zeros in \code{event}s in
\code{df}.}

\item{p_rate}{Hypothesized Poisson rate parameter null value at which the
Poisson test is performed (null vs. greater). See details for more.

Default: \code{0.2}}

\item{p_crit}{Critical p-value for the Poisson test..

Default: \code{0.05}}
}
\value{
A named list of class \code{mdsstat_test} object, as follows:
\describe{
  \item{test_name}{Name of the test run}
  \item{analysis_of}{English description of what was analyzed}
  \item{status}{Named boolean of whether the test was run. The name contains
  the run status.}
  \item{result}{A standardized list of test run results: \code{statistic}
  for the test statistic, \code{lcl} and \code{ucl} for the 95%
  confidence bounds, \code{p} for the p-value, \code{signal} status, and
  \code{signal_threshold}.}
  \item{params}{The test parameters}
  \item{data}{The data on which the test was run}
}
}
\description{
Test on rare events using an exact test on the Poisson distribution rate
parameter (\code{stats::poisson.test()}).
}
\details{
\code{p_rate} default of \code{0.2} is a suggested null value for
the Poisson rate parameter. However this value is highly advised to be set
based on known priors and/or your specific application.
}
\section{Methods (by class)}{
\itemize{
\item \code{mds_ts}: Poisson on mds_ts data

\item \code{default}: Poisson on general data
}}

\examples{
# Basic Example
data <- data.frame(time=c(1:8), event=c(rep(0, 6), stats::rpois(2, 4)))
a1 <- poisson_rare(data)
# Example using an mds_ts object
a2 <- poisson_rare(mds_ts[[1]])
# Example using a derived rate as the "event"
data <- mds_ts[[1]]
data$rate <- ifelse(is.na(data$nA), 0, data$nA) / data$exposure
a3 <- poisson_rare(data, c("Rate"="rate"))
}
