\name{filter_wells}
\alias{filter_wells}

\title{Filter wells}
\description{Filter out wells for which the number of active electrodes is less than 4, at least 70 percent of the time}

\usage{
filter_wells(unfiltered_df, nae,min_electrodes = 4, 
well_max_div_inactive_ratio = 0.5)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{unfiltered_df}{Dataframe generated by the spike_features() function
}
  \item{nae}{A dataframe containing the number of active electrodes for the recording
}
  \item{min_electrodes}{Minimum number of active electrode to consider a well for analysis
}
  \item{well_max_div_inactive_ratio}{The DIV inactive/active well ratio below which a well will be considered active for a set of DIVs
}
}
\value{A dataframe identical in format to the input, except that wells that do not meet the filtering criteria are removed.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
\donttest{

	data("S")
	data("parameters")
	s<-list(); s[[1]]<-S
	spike_features<-aggregate_features(s, feat_type="spike", parameters )
	nae = spike_features$nae
  filtered.spike.features = lapply(spike_features, function(x) filter_wells(x, nae))
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ filter }
\keyword{ well }% __ONLY ONE__ keyword per line
