% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sttc.R
\name{compute_mean_sttc_by_well}
\alias{compute_mean_sttc_by_well}
\title{Compute the mean STTC averaged across all pairwise electrodes in well}
\usage{
compute_mean_sttc_by_well(s, dt = 0.05, beg = NULL, end = NULL)
}
\arguments{
\item{s}{structure storing the well information}

\item{dt}{Time window for STTC (default = 0.05 seconds)}

\item{beg}{Start time in seconds (defaults to start of recording)}

\item{end}{End time in seconds (defaults to end of recording)}
}
\value{
A vector giving the mean of all pairwise STTCs on each well.
}
\description{
Compute the mean STTC averaged across all pairwise electrodes in well
}
\details{
For each pair of electrodes, we calculate the STTC.  We then take
the mean of these pairs, excluding autocorrelations.  If a well has
one (or no) electrodes, the value returned for that well is NULL.

Warning: taking the mean over a well is useful only if you do not
suspect distance-dependent correlations in your firing.  (For
activity like retinal waves, we find that correlations are
strongly dependent on the distance separating electrodes.)
}
\author{
Stephen Eglen
}
