% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_module.R
\name{cal_module}
\alias{cal_module}
\title{Assign modules to each network}
\usage{
cal_module(
  network_list,
  undirected_method = "cluster_fast_greedy",
  directed_method = "cluster_optimal",
  ...
)
}
\arguments{
\item{network_list}{a list with multiple networks; all the networks should be trans_network object created from \code{\link{trans_network}} class of \code{microeco} package.}

\item{undirected_method}{default "cluster_fast_greedy"; the modularity algorithm for undirected network; 
see \code{cal_module} function of \code{\link{trans_network}} class for more algorithms.}

\item{directed_method}{default 'cluster_optimal'; the modularity algorithm for directed network.}

\item{...}{other parameters (except for method) passed to \code{cal_module} function of \code{\link{trans_network}} class.}
}
\value{
\code{list}, with module attribute in nodes of each network
}
\description{
Calculating modularity of networks and assign the modules to nodes for each network.
}
\examples{
data(soil_amp_network)
soil_amp_network <- cal_module(soil_amp_network)

}
