% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.forest.R
\name{plot.forest}
\alias{plot.forest}
\alias{shinyplot.forest}
\title{Plot forest attributes}
\usage{
\method{plot}{forest}(
  x,
  SpParams,
  type = "LeafAreaDensity",
  byCohorts = FALSE,
  bySpecies = FALSE,
  includeHerbs = FALSE,
  ...
)

\method{shinyplot}{forest}(x, SpParams, ...)
}
\arguments{
\item{x}{An object of class \code{\link{forest}}.}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}).}

\item{type}{A string of the plot type: "LeafAreaDensity", "RootDistribution", "FuelBulkDensity", "PARExtinction", "SWRExtinction" or "WindExtinction".}

\item{byCohorts}{A logical flag to separate profiles for each cohort.}

\item{bySpecies}{A logical flag to aggregate results by species.}

\item{includeHerbs}{A logical flag to include herbaceous layer in the profile.}

\item{\dots}{Additional parameters to vertical profiles}
}
\value{
A ggplot or a shiny application, depending on the function.
}
\description{
Convenient wrappers for vertical forest profiles (see \code{\link{vprofile_leafAreaDensity}}).
}
\examples{
data(exampleforest)
data(SpParamsMED)
plot(exampleforest, SpParamsMED)

}
\seealso{
\code{\link{vprofile_leafAreaDensity}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
