% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medicalcoder-pkg.R
\docType{package}
\name{medicalcoder-package}
\alias{medicalcoder}
\alias{medicalcoder-package}
\title{medicalcoder}
\description{
An R package for working with ICD codes and comorbidity assessments.
}
\details{
\code{medicalcoder} is a lightweight, base-R package for working with ICD-9 and
ICD-10 diagnosis and procedure codes. It provides fast, dependency-free tools
to look up, validate, and manipulate ICD codes, while also implementing
widely used comorbidity algorithms such as Charlson, Elixhauser, and the
Pediatric Complex Chronic Conditions (PCCC).
Designed for portability and reproducibility, the package avoids external
dependencies—requiring only R >= 3.5.0—yet offers a rich set of curated ICD
code libraries from the United States' Centers for Medicare and Medicaid
Services (CMS), Centers for Disease Control (CDC), and the World Health
Organization (WHO).

The package balances performance with elegance: its internal caching,
efficient joins, and compact data structures make it practical for
large-scale health data analyses, while its clean design makes it easy to
extend or audit. Whether you need to flag comorbidities, explore ICD
hierarchies, or standardize clinical coding workflows, \code{medicalcoder} provides
a robust, transparent foundation for research and applied work in biomedical
informatics.
}
\section{Implementation}{
The \code{medicalcoder} package was intentionally designed and built to have zero
dependencies beyond R version 3.5.0 (needed due to a \href{https://cran.r-project.org/src/base/NEWS.3#:~:text=R\%20has\%20new,to\%20version\%203.5.0.}{change in data serialization})
and zero imports.  The package is completely self contained for the purposes
of installation and use.

This design choice was made for several reasons.
\enumerate{
\item Ease of installation:
\itemize{
\item Only requirement is R >= 3.5.0.
\item No need for external files or downloads or other packages for the ICD data-base.
}
\item Works well with different data paradigms
\itemize{
\item Base R \code{data.frames},
\item \href{https://www.tidyverse.org/}{tidyverse} \code{tibble}s, and
\item \code{data.table}s from the \href{https://rdatatable.gitlab.io/data.table/}{data.table} package.
}
}

One of the reasons for focusing on building a self-contained package with no
need for additional namespaces is to make installation and use in an
pseudo-air-gapped system easier.  The author of this package routinely works
on machines with extremely limited, access to the world-wide-web.  As
such, relying on any system dependencies or other R packages can become
difficult as the machine may or may not have the needed software.  So long as
R >= 3.5.0 is available \code{medicalcoder} will work.

A great deal of thought went into performance of the methods and the size of
the package.  The internal data sets, for example, are not stored in a
structure that is easy to use by end user.  When the package namespaces is
loaded the needed internal lookup tables are generated and cached.
}

\seealso{
\code{\link[=comorbidities]{comorbidities()}}, \code{\link[=get_icd_codes]{get_icd_codes()}}, \code{\link[=is_icd]{is_icd()}},
\itemize{
\item Vignette for working with ICD codes:
\itemize{
\item \code{vignette(topic = "icd", package = "medicalcoder")}
}
\item Vignettes for applying comorbidities:
\itemize{
\item \code{vignette(topic = "comorbidities", package = "medicalcoder")}
\item \code{vignette(topic = "pccc", package = "medicalcoder")}
\item \code{vignette(topic = "charlson", package = "medicalcoder")}
\item \code{vignette(topic = "elixhauser", package = "medicalcoder")}
}
}
}
\author{
\strong{Maintainer}: Peter DeWitt \email{peter.dewitt@cuanschutz.edu} (\href{https://orcid.org/0000-0002-6391-0795}{ORCID})

Other contributors:
\itemize{
  \item Tell Bennett \email{tell.bennett@cuanschutz.edu} (\href{https://orcid.org/0000-0003-1483-4236}{ORCID}) [contributor]
  \item Seth Russell \email{seth.russell@cuanschutz.edu} (\href{https://orcid.org/0000-0002-2436-1367}{ORCID}) [contributor]
  \item Meg Rebull \email{meg.rebull@cuanschutz.edu} (\href{https://orcid.org/0000-0003-0334-4223}{ORCID}) [contributor]
}

}
\keyword{internal}
