% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mx_download.R
\name{mx_download}
\alias{mx_download}
\title{Download PDF's of preprints returned by a search}
\usage{
mx_download(
  mx_results,
  directory,
  create = TRUE,
  name = c("ID", "DOI"),
  print_update = 10
)
}
\arguments{
\item{mx_results}{Vector containing the links to the medRxiv PDFs}

\item{directory}{The location you want to download the PDF's to}

\item{create}{TRUE or FALSE. If TRUE, creates the directory if it doesn't
exist}

\item{name}{How to name the downloaded PDF. By default, both the ID number of
the record and the DOI are used.}

\item{print_update}{How frequently to print an update}
}
\description{
Download PDF's of all the papers in your search results
}
\examples{
\donttest{
mx_results <- mx_search(mx_snapshot(), query = "10.1101/2020.02.25.20021568")
mx_download(mx_results, directory=tempdir())
}
}
\seealso{
Other helper: 
\code{\link{mx_crosscheck}()},
\code{\link{mx_export}()}
}
\concept{helper}
