% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot-methods.R
\name{plot}
\alias{plot}
\alias{plot,ConfregEL-method}
\alias{plot,ELD-method}
\title{Plot methods}
\usage{
\S4method{plot}{ConfregEL}(x, y, ...)

\S4method{plot}{ELD}(x, y, ...)
}
\arguments{
\item{x}{An object to be plotted.}

\item{y}{Not used.}

\item{...}{Further graphical parameters (see \code{\link{par}}).}
}
\description{
Provides plot methods for objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{ConfregEL}: Plots a two-dimensional confidence region for model
parameters.

\item \code{ELD}: Plots empirical likelihood displacement values versus
observation index.
}}

\examples{
## Model
data("mtcars")
fit <- el_lm(hp ~ wt, data = mtcars)

## Confidence region
out1 <- confreg(fit, npoints = 500)
plot(out1)

## Empirical likelihood displacement
out2 <- eld(fit)
plot(out2)
}
\seealso{
\code{\link[=confreg]{confreg()}}, \code{\link[=eld]{eld()}}
}
