% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/confreg-methods.R
\name{confreg}
\alias{confreg}
\alias{confreg,EL-method}
\title{Confidence region for model parameters}
\usage{
\S4method{confreg}{EL}(
  object,
  parm,
  level = 0.95,
  cv = NULL,
  npoints = 50L,
  control = el_control()
)
}
\arguments{
\item{object}{An object that inherits from \linkS4class{EL}.}

\item{parm}{A specification of which parameters are to be given a confidence
region, either a vector of numbers or a vector of names. It must be a
vector of length two of the form `c(x, y)`. If missing, the first two
parameter in `object` are considered.}

\item{level}{A single numeric for the confidence level required. Defaults to
`0.95`. It is ignored if `cv` is non-`NULL`.}

\item{cv}{A single numeric for the critical value for calibration of
empirical likelihood ratio statistic. Defaults to NULL and set to
`qchisq(level, 2L)`. It must be compatible with the `th` value in
`control`.}

\item{npoints}{A single integer for the number of boundary points to compute.
Defaults to `50`.}

\item{control}{An object of class \linkS4class{ControlEL} constructed by
[el_control()].}
}
\value{
An object of class \linkS4class{ConfregEL}.
}
\description{
Computes boundary points of a two-dimensional confidence region for model
  parameters.
}
\examples{
data("mtcars")
fit <- el_lm(mpg ~ wt + qsec, data = mtcars)
cr <- confreg(fit, parm = c(2, 3), cv = qchisq(0.90, 2))
plot(cr)
}
\references{
Owen A (1990).
  “Empirical Likelihood Ratio Confidence Regions.”
  \emph{The Annals of Statistics}, 18(1), 90--120.
  \doi{10.1214/aos/1176347494}.
}
\seealso{
[confint()], [elt()], [plot()], [el_control()]
}
