% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/logLik-methods.R
\name{logLik}
\alias{logLik}
\alias{logLik,EL-method}
\title{Maximum empirical log-likelihood}
\usage{
\S4method{logLik}{EL}(object, ...)
}
\arguments{
\item{object}{An object that inherits from \linkS4class{EL}.}

\item{...}{Further arguments passed to methods.}
}
\value{
An object of class \linkS4class{logLikEL}.
}
\description{
Extracts empirical log-likelihood from a model evaluated at the estimated
  coefficients.
}
\details{
Let \eqn{X_i} be independent and identically distributed
  \eqn{p}-dimensional random variable from an unknown distribution \eqn{P}
  for \eqn{i = 1, \dots, n}. We assume that \eqn{P} has a positive definite
  covariance matrix. For a parameter of interest
  \eqn{\theta(F) \in {\rm{I\!R}}^p}, consider a \eqn{p}-dimensional smooth
  estimating function \eqn{g(X_i, \theta)} with a moment condition
  \deqn{\textrm{E}[g(X_i, \theta)] = 0.}
  We assume that there exists an unique \eqn{\theta_0} that solves the above
  equation. Given a value of \eqn{\theta}, the (profile) empirical likelihood
  ratio is defined by
  \deqn{R(\theta) =
  \max_{p_i}\left\{\prod_{i = 1}^n np_i :
  \sum_{i = 1}^n p_i g(X_i, \theta) = 0, p_i \geq 0, \sum_{i = 1}^n p_i = 1
  \right\}.}
  The maximum empirical likelihood estimator \eqn{\hat{\theta}} solves
  \eqn{n^{-1}\sum_{i = 1}^n g(X_i, \hat{\theta}) = 0} and yields
  \eqn{p_i = 1/n} for \eqn{i = 1, \dots, n}. [logLik()] gives \eqn{-n\log n},
  the maximum empirical log-likelihood. Use [logL()] instead to extract the
  (constrained) empirical log-likelihood computed from a model.
}
\examples{
data("precip")
fit <- el_mean(precip, par = 40)
logLik(fit)
}
\seealso{
\linkS4class{EL}, [logL()]
}
