% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{SummaryLM-class}
\alias{SummaryLM-class}
\alias{SummaryLM}
\title{\linkS4class{SummaryLM} class}
\description{
S4 class for a summary of \linkS4class{LM} objects.
}
\section{Slots}{

\describe{
\item{\code{sigTests}}{A numeric matrix of the results of significance tests.}

\item{\code{intercept}}{A single logical for whether the given model has an intercept
term or not.}

\item{\code{na.action}}{Information returned by \code{\link{model.frame}} on the special
handling of \code{NA}s.}

\item{\code{call}}{A matched call.}

\item{\code{terms}}{A \code{\link{terms}} object used.}

\item{\code{aliased}}{A named logical vector showing if the original coefficients are
aliased.}

\item{\code{optim}}{A list of the following optimization results:
\itemize{
\item \code{par} A numeric vector of the solution to the (constrained) optimization
problem.
\item \code{lambda} A numeric vector of the Lagrange multipliers of the dual
problem corresponding to \code{par}.
\item \code{iterations} A single integer for the number of iterations performed.
\item \code{convergence} A single logical for the convergence status.
\item \code{cstr} A single logical for whether constrained EL optimization is
performed or not.
}}

\item{\code{logl}}{A single numeric of the empirical log-likelihood.}

\item{\code{loglr}}{A single numeric of the empirical log-likelihood ratio.}

\item{\code{statistic}}{A single numeric of minus twice the (constrained) empirical
log-likelihood ratio for the overall test.}

\item{\code{df}}{A single integer for the degrees of freedom of the statistic.}

\item{\code{pval}}{A single numeric for the \eqn{p}-value of the statistic.}

\item{\code{nobs}}{A single integer for the number of observations.}

\item{\code{npar}}{A single integer for the number of parameters.}

\item{\code{weighted}}{A single logical for whether the data are weighted or not.}

\item{\code{coefficients}}{A numeric vector of the maximum empirical likelihood
estimates of the parameters.}

\item{\code{method}}{A single character for the method dispatch in internal
functions.}

\item{\code{control}}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}.}
}}

\examples{
showClass("SummaryLM")
}
