% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback.R
\name{callback}
\alias{callback}
\alias{ChunkCallback}
\alias{SideEffectChunkCallback}
\alias{DataFrameCallback}
\alias{ListCallback}
\alias{AccumulateCallback}
\title{Callback classes}
\description{
These classes are used to define callback behaviors.
}
\details{
\describe{
\item{ChunkCallback}{Callback interface definition, all callback functions should inherit from this class.}
\item{SideEffectChunkCallback}{Callback function that is used only for side effects, no results are returned.}
\item{DataFrameCallback}{Callback function that combines each result together at the end.}
\item{AccumulateCallBack}{
Callback function that accumulates a single result. Requires the parameter \code{acc} to specify
the initial value of the accumulator.  The parameter \code{acc} is \code{NULL} by default.
}
}
}
\seealso{
Other chunked: 
\code{\link{melt_delim_chunked}()}
}
\concept{chunked}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ChunkCallback-new}{\code{ChunkCallback$new()}}
\item \href{#method-ChunkCallback-receive}{\code{ChunkCallback$receive()}}
\item \href{#method-ChunkCallback-continue}{\code{ChunkCallback$continue()}}
\item \href{#method-ChunkCallback-result}{\code{ChunkCallback$result()}}
\item \href{#method-ChunkCallback-finally}{\code{ChunkCallback$finally()}}
\item \href{#method-ChunkCallback-clone}{\code{ChunkCallback$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChunkCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-ChunkCallback-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChunkCallback-receive"></a>}}
\if{latex}{\out{\hypertarget{method-ChunkCallback-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChunkCallback-continue"></a>}}
\if{latex}{\out{\hypertarget{method-ChunkCallback-continue}{}}}
\subsection{Method \code{continue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$continue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChunkCallback-result"></a>}}
\if{latex}{\out{\hypertarget{method-ChunkCallback-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChunkCallback-finally"></a>}}
\if{latex}{\out{\hypertarget{method-ChunkCallback-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChunkCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ChunkCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[meltr:ChunkCallback]{meltr::ChunkCallback}} -> \code{SideEffectChunkCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SideEffectChunkCallback-new}{\code{SideEffectChunkCallback$new()}}
\item \href{#method-SideEffectChunkCallback-receive}{\code{SideEffectChunkCallback$receive()}}
\item \href{#method-SideEffectChunkCallback-continue}{\code{SideEffectChunkCallback$continue()}}
\item \href{#method-SideEffectChunkCallback-clone}{\code{SideEffectChunkCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="meltr" data-topic="ChunkCallback" data-id="finally"><a href='../../meltr/html/ChunkCallback.html#method-ChunkCallback-finally'><code>meltr::ChunkCallback$finally()</code></a></span></li>
<li><span class="pkg-link" data-pkg="meltr" data-topic="ChunkCallback" data-id="result"><a href='../../meltr/html/ChunkCallback.html#method-ChunkCallback-result'><code>meltr::ChunkCallback$result()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SideEffectChunkCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-SideEffectChunkCallback-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SideEffectChunkCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SideEffectChunkCallback-receive"></a>}}
\if{latex}{\out{\hypertarget{method-SideEffectChunkCallback-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SideEffectChunkCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SideEffectChunkCallback-continue"></a>}}
\if{latex}{\out{\hypertarget{method-SideEffectChunkCallback-continue}{}}}
\subsection{Method \code{continue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SideEffectChunkCallback$continue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SideEffectChunkCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SideEffectChunkCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SideEffectChunkCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[meltr:ChunkCallback]{meltr::ChunkCallback}} -> \code{DataFrameCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataFrameCallback-new}{\code{DataFrameCallback$new()}}
\item \href{#method-DataFrameCallback-receive}{\code{DataFrameCallback$receive()}}
\item \href{#method-DataFrameCallback-result}{\code{DataFrameCallback$result()}}
\item \href{#method-DataFrameCallback-finally}{\code{DataFrameCallback$finally()}}
\item \href{#method-DataFrameCallback-clone}{\code{DataFrameCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="meltr" data-topic="ChunkCallback" data-id="continue"><a href='../../meltr/html/ChunkCallback.html#method-ChunkCallback-continue'><code>meltr::ChunkCallback$continue()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataFrameCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataFrameCallback-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataFrameCallback-receive"></a>}}
\if{latex}{\out{\hypertarget{method-DataFrameCallback-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataFrameCallback-result"></a>}}
\if{latex}{\out{\hypertarget{method-DataFrameCallback-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataFrameCallback-finally"></a>}}
\if{latex}{\out{\hypertarget{method-DataFrameCallback-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataFrameCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataFrameCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataFrameCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[meltr:ChunkCallback]{meltr::ChunkCallback}} -> \code{ListCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ListCallback-new}{\code{ListCallback$new()}}
\item \href{#method-ListCallback-receive}{\code{ListCallback$receive()}}
\item \href{#method-ListCallback-result}{\code{ListCallback$result()}}
\item \href{#method-ListCallback-finally}{\code{ListCallback$finally()}}
\item \href{#method-ListCallback-clone}{\code{ListCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="meltr" data-topic="ChunkCallback" data-id="continue"><a href='../../meltr/html/ChunkCallback.html#method-ChunkCallback-continue'><code>meltr::ChunkCallback$continue()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-ListCallback-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListCallback-receive"></a>}}
\if{latex}{\out{\hypertarget{method-ListCallback-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListCallback-result"></a>}}
\if{latex}{\out{\hypertarget{method-ListCallback-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListCallback-finally"></a>}}
\if{latex}{\out{\hypertarget{method-ListCallback-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ListCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ListCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ListCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[meltr:ChunkCallback]{meltr::ChunkCallback}} -> \code{AccumulateCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AccumulateCallback-new}{\code{AccumulateCallback$new()}}
\item \href{#method-AccumulateCallback-receive}{\code{AccumulateCallback$receive()}}
\item \href{#method-AccumulateCallback-result}{\code{AccumulateCallback$result()}}
\item \href{#method-AccumulateCallback-clone}{\code{AccumulateCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="meltr" data-topic="ChunkCallback" data-id="continue"><a href='../../meltr/html/ChunkCallback.html#method-ChunkCallback-continue'><code>meltr::ChunkCallback$continue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="meltr" data-topic="ChunkCallback" data-id="finally"><a href='../../meltr/html/ChunkCallback.html#method-ChunkCallback-finally'><code>meltr::ChunkCallback$finally()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AccumulateCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-AccumulateCallback-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AccumulateCallback$new(callback, acc = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AccumulateCallback-receive"></a>}}
\if{latex}{\out{\hypertarget{method-AccumulateCallback-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AccumulateCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AccumulateCallback-result"></a>}}
\if{latex}{\out{\hypertarget{method-AccumulateCallback-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AccumulateCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AccumulateCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AccumulateCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AccumulateCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
