% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/meminfo.r
\name{filesize}
\alias{Sys.filesize}
\alias{filesize}
\title{filesize}
\usage{
Sys.filesize(filename)
}
\arguments{
\item{filename}{Location of the file (as a string).}
}
\value{
A memuse class object.
}
\description{
Returns size of a file as reported by the file system (the
file is not scanned).
}
\details{
All of the C-level source code for these methods (in src/meminfo of the root
directory of the memuse source tree) is licensed under the permissive
2-Clause BSD license.
}
\examples{
\dontrun{
library(memuse)

x <- rnorm(1e5)
object.size(x) ### size in ram

tmp <- tempfile()
saveRDS(x, file=tmp)
Sys.filesize(tmp) ### size on disk
unlink(tmp)
}
}

