% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merFastDisplay.R
\name{fastdisp}
\alias{fastdisp}
\alias{fastdisp.merMod}
\alias{fastdisp.merModList}
\title{fastdisp: faster display of model summaries}
\usage{
fastdisp(x, ...)

\method{fastdisp}{merMod}(x, ...)

\method{fastdisp}{merModList}(x, ...)
}
\arguments{
\item{x}{a model object}

\item{...}{additional arguments to pass to \code{arm::\link[arm]{display}}
including number of digits}
}
\value{
A printed summary of a x object
}
\description{
Display model fit summary of x or x like objects, fast
}
\details{
Faster than the implementation in the arm package because it avoids refitting

The time saving is only noticeable for large, time-consuming (g)lmer
fits.
}
\examples{
\donttest{
#Compare the time for displaying this modest model
require(arm)
m1 <- lmer(y ~ lectage + studage + (1|d) + (1|s), data=InstEval)
system.time(display(m1))
system.time(fastdisp(m1))
}
}
\seealso{
\code{\link[arm]{display}}
}
