% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RepeatCircular.R
\name{WrapCircular}
\alias{WrapCircular}
\alias{RepeatCircular}
\title{Wrap periodic data to any range}
\usage{
WrapCircular(x, circular = "lon", wrap = c(0, 360))
}
\arguments{
\item{x}{a data.frame}

\item{circular}{the name of the circular dimension}

\item{wrap}{the wrap for the data to be extended to}
}
\value{
A data.frame.
}
\description{
Periodic data can be defined only in one period and be extended to any arbitrary
range.
}
\examples{
library(ggplot2)
library(data.table)
data(geopotential)
g <- ggplot(geopotential[date == date[1]], aes(lon, lat)) +
    geom_contour(aes(z = gh)) +
    coord_polar() +
    ylim(c(-90, -10))

# This plot has problems in lon = 0
g

# But using WrapCircular solves it.
g \%+\% WrapCircular(geopotential[date == date[1]], "lon", c(0, 360))

# Aditionally data can be just repeatet to the right and
# left
ggplot(WrapCircular(geopotential[date == date[1]], wrap = c(-180, 360 + 180)),
       aes(lon, lat)) +
    geom_contour(aes(z = gh))

# The same behaviour is now implemented directly in geom_contour2
# and geom_contour_fill
ggplot(geopotential[date == date[1]], aes(lon, lat)) +
    geom_contour2(aes(z = gh), xwrap = c(-180, 360 + 180))

}
\seealso{
geom_contour2

Other ggplot2 helpers: 
\code{\link{DivideTimeseries}()},
\code{\link{MakeBreaks}()},
\code{\link{geom_arrow}()},
\code{\link{geom_contour2}()},
\code{\link{geom_contour_fill}()},
\code{\link{geom_label_contour}()},
\code{\link{geom_relief}()},
\code{\link{geom_streamline}()},
\code{\link{guide_colourstrip}()},
\code{\link{map_labels}},
\code{\link{reverselog_trans}()},
\code{\link{scale_divergent}},
\code{\link{scale_longitude}},
\code{\link{stat_na}()},
\code{\link{stat_subset}()}
}
\concept{ggplot2 helpers}
