% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_subset.R
\docType{data}
\name{stat_subset}
\alias{stat_subset}
\alias{StatSubset}
\title{Subset values}
\usage{
stat_subset(mapping = NULL, data = NULL, geom = "point",
  position = "identity", ..., show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}
}
\description{
Removes values where \code{subset} evaluates to \code{FALSE}. Useful for showing only
statistical significant values, or an interesting subset of the data without
manually subsetting the data.
}
\section{Aesthetics}{

\code{stat_subset} understands the following aesthetics (required aesthetics are in bold)

\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{subset}
\item \code{width}
\item \code{height}
}
}

\examples{

library(ggplot2)
ggplot(data.table::melt(volcano), aes(Var1, Var2)) +
    geom_contour(aes(z = value)) +
    stat_subset(aes(subset = value >= 150 & value <= 160),
                shape = 3, color = "red")

}
\seealso{
\link{stat_na} for a more specialized stat for filtering \code{NA} values.

Other ggplot2 helpers: \code{\link{DivideTimeseries}},
  \code{\link{MakeBreaks}}, \code{\link{WrapCircular}},
  \code{\link{geom_arrow}}, \code{\link{geom_contour2}},
  \code{\link{geom_contour_fill}},
  \code{\link{geom_label_contour}},
  \code{\link{geom_relief}}, \code{\link{geom_streamline}},
  \code{\link{guide_colourstrip}},
  \code{\link{map_labels}}, \code{\link{reverselog_trans}},
  \code{\link{scale_divergent}},
  \code{\link{scale_longitude}}, \code{\link{stat_na}}
}
\concept{ggplot2 helpers}
\keyword{datasets}
