% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.meta.R
\name{print.meta}
\alias{print.meta}
\alias{cilayout}
\title{Print meta-analysis results}
\usage{
\method{print}{meta}(
  x,
  fixed = x$fixed,
  random = x$random,
  prediction = x$prediction,
  overall = x$overall,
  overall.hetstat = x$overall.hetstat,
  test.subgroup = x$test.subgroup,
  test.subgroup.fixed = test.subgroup & fixed,
  test.subgroup.random = test.subgroup & random,
  backtransf = x$backtransf,
  pscale = x$pscale,
  irscale = x$irscale,
  irunit = x$irunit,
  subgroup.name = x$subgroup.name,
  print.subgroup.name = x$print.subgroup.name,
  sep.subgroup = x$sep.subgroup,
  nchar.subgroup = 35,
  header = TRUE,
  print.CMH = x$print.CMH,
  digits = gs("digits"),
  digits.stat = gs("digits.stat"),
  digits.pval = max(gs("digits.pval"), 2),
  digits.pval.Q = max(gs("digits.pval.Q"), 2),
  digits.Q = gs("digits.Q"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  digits.H = gs("digits.H"),
  digits.I2 = gs("digits.I2"),
  scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"),
  zero.pval = gs("zero.pval"),
  JAMA.pval = gs("JAMA.pval"),
  print.tau2 = TRUE,
  print.tau = TRUE,
  print.I2 = gs("print.I2"),
  print.H = gs("print.H"),
  print.Rb = gs("print.Rb"),
  text.tau2 = gs("text.tau2"),
  text.tau = gs("text.tau"),
  text.I2 = gs("text.I2"),
  text.Rb = gs("text.Rb"),
  details.methods = TRUE,
  warn.backtransf = FALSE,
  ...
)

cilayout(bracket = "[", separator = "; ")
}
\arguments{
\item{x}{An object of class \code{meta}.}

\item{fixed}{A logical indicating whether a fixed effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{test.subgroup.fixed}{A logical value indicating whether to
print results of test for subgroup differences (based on fixed
effect / common effect model).}

\item{test.subgroup.random}{A logical value indicating whether to
print results of test for subgroup differences (based on random
effects model).}

\item{backtransf}{A logical indicating whether printed results
should be back transformed. If \code{backtransf=TRUE}, results
for \code{sm="OR"} are printed as odds ratios rather than log
odds ratios and results for \code{sm="ZCOR"} are printed as
correlations rather than Fisher's z transformed correlations, for
example.}

\item{pscale}{A numeric giving scaling factor for printing of
single event probabilities or risk differences, i.e. if argument
\code{sm} is equal to \code{"PLOGIT"}, \code{"PLN"},
\code{"PRAW"}, \code{"PAS"}, \code{"PFT"}, or \code{"RD"}.}

\item{irscale}{A numeric defining a scaling factor for printing of
single incidence rates or incidence rate differences, i.e. if
argument \code{sm} is equal to \code{"IR"}, \code{"IRLN"},
\code{"IRS"}, \code{"IRFT"}, or \code{"IRD"}.}

\item{irunit}{A character specifying the time unit used to
calculate rates, e.g. person-years.}

\item{subgroup.name}{A character string with a name for the
grouping variable.}

\item{print.subgroup.name}{A logical indicating whether the name of
the grouping variable should be printed in front of the group
labels.}

\item{sep.subgroup}{A character string defining the separator
between label and levels of grouping variable.}

\item{nchar.subgroup}{A numeric specifying the number of characters
to print from subgroup labels.}

\item{header}{A logical indicating whether information on title of
meta-analysis, comparison and outcome should be printed at the
beginning of the printout.}

\item{print.CMH}{A logical indicating whether result of the
Cochran-Mantel-Haenszel test for overall effect should be
printed.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.stat}{Minimal number of significant digits for z- or
t-value of test for overall effect, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of overall treatment effect, see \code{print.default}.}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity test, see \code{print.default}.}

\item{digits.Q}{Minimal number of significant digits for
heterogeneity statistic Q, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance \eqn{\tau^2}, see \code{print.default}.}

\item{digits.tau}{Minimal number of significant digits for
\eqn{\tau}, the square root of the between-study variance
\eqn{\tau^2}.}

\item{digits.H}{Minimal number of significant digits for H
statistic, see \code{print.default}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
and Rb statistic, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{big.mark}{A character used as thousands separator.}

\item{zero.pval}{A logical specifying whether p-values should be
printed with a leading zero.}

\item{JAMA.pval}{A logical specifying whether p-values for test of
overall effect should be printed according to JAMA reporting
standards.}

\item{print.tau2}{A logical specifying whether between-study
variance \eqn{\tau^2} should be printed.}

\item{print.tau}{A logical specifying whether \eqn{\tau}, the
square root of the between-study variance \eqn{\tau^2}, should be
printed.}

\item{print.I2}{A logical specifying whether heterogeneity
statistic I\eqn{^2} should be printed.}

\item{print.H}{A logical specifying whether heterogeneity statistic
H should be printed.}

\item{print.Rb}{A logical specifying whether heterogeneity
statistic R\eqn{_b} should be printed.}

\item{text.tau2}{Text printed to identify between-study variance
\eqn{\tau^2}.}

\item{text.tau}{Text printed to identify \eqn{\tau}, the square
root of the between-study variance \eqn{\tau^2}.}

\item{text.I2}{Text printed to identify heterogeneity statistic
I\eqn{^2}.}

\item{text.Rb}{Text printed to identify heterogeneity statistic
R\eqn{_b}.}

\item{details.methods}{A logical specifying whether details on
statistical methods should be printed.}

\item{warn.backtransf}{A logical indicating whether a warning
should be printed if backtransformed proportions and rates are
below 0 and backtransformed proportions are above 1.}

\item{\dots}{Additional arguments (passed on to \code{prmatrix}).}

\item{bracket}{A character with bracket symbol to print lower
confidence interval: "[", "(", "\{", "".}

\item{separator}{A character string with information on separator
between lower and upper confidence interval.}
}
\description{
Print method for objects of class \code{meta}.

R function cilayout can be utilised to change the layout to print
confidence intervals (both in printout from print.meta and
print.summary.meta function as well as in forest plots). The
default layout is "[lower; upper]". Another popular layout is
"(lower - upper)" which is used throughout an R session by using R
command \code{cilayout("(", " - ")}.

Argument \code{pscale} can be used to rescale single proportions or
risk differences, e.g. \code{pscale = 1000} means that proportions
are expressed as events per 1000 observations. This is useful in
situations with (very) low event probabilities.

Argument \code{irscale} can be used to rescale single rates or rate
differences, e.g. \code{irscale = 1000} means that rates are
expressed as events per 1000 time units, e.g. person-years. This is
useful in situations with (very) low rates. Argument \code{irunit}
can be used to specify the time unit used in individual studies
(default: "person-years"). This information is printed in summaries
and forest plots if argument \code{irscale} is not equal to 1.
}
